/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.teleport;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class ChunkTicket {
    @Nonnull
    private final ForgeChunkManager.Ticket ticket;
    private long discardTime;
    private static final List<ChunkTicket> TICKETS = new NNList();

    private ChunkTicket(@Nonnull ForgeChunkManager.Ticket ticket) {
        this.ticket = ticket;
        this.discardTime = EnderIO.proxy.getServerTickCount() + 100L;
    }

    private boolean isForPlayer(@Nonnull EntityPlayerMP player, @Nonnull World world) {
        if (this.ticket.getPlayerName().equals(player.func_110124_au().toString()) && this.ticket.world == world) {
            this.discardTime = EnderIO.proxy.getServerTickCount() + 100L;
            return true;
        }
        return false;
    }

    private boolean shallDiscard() {
        if (this.discardTime < EnderIO.proxy.getServerTickCount()) {
            Log.debug("Discarding ticket for ", this.ticket.getPlayerName());
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)EnderIO.instance, null);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        TICKETS.clear();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !TICKETS.isEmpty()) {
            Iterator<ChunkTicket> i = TICKETS.iterator();
            while (i.hasNext()) {
                if (!i.next().shallDiscard()) continue;
                i.remove();
            }
        }
    }

    public static void loadChunk(@Nonnull EntityPlayerMP player, @Nonnull World world, @Nonnull BlockPos pos) {
        if (DiagnosticsConfig.experimentalChunkLoadTeleport.get().booleanValue()) {
            ForgeChunkManager.Ticket ticket;
            String playerID = player.func_110124_au().toString();
            ChunkTicket discard = null;
            if (!TICKETS.isEmpty()) {
                Iterator<ChunkTicket> i = TICKETS.iterator();
                while (i.hasNext() && discard == null) {
                    discard = i.next();
                    if (discard.isForPlayer(player, world)) continue;
                    discard = null;
                }
            }
            if (discard == null && (ticket = ForgeChunkManager.requestPlayerTicket((Object)EnderIO.instance, (String)playerID, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
                ticket.setChunkListDepth(2);
                discard = new ChunkTicket(ticket);
                TICKETS.add(discard);
            }
            if (discard != null) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)discard.ticket, (ChunkPos)new ChunkPos(pos));
                Log.debug("Forcing chunk ", new ChunkPos(pos), " for " + discard.ticket.getPlayerName());
            }
        }
    }
}

