/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.registry;

import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextureRegistry {
    @Nonnull
    private static final TextureSupplier noSupplier = new TextureSupplier(){

        @Override
        @Nonnull
        public <T> T get(@Nonnull Class<T> clazz) {
            Log.error("Client side method TextureSupplier.get() called on server!");
            return null;
        }
    };
    private static TextureRegistryServer instance;

    @Nonnull
    public static TextureSupplier registerTexture(@Nonnull String location) {
        return TextureRegistry.registerTexture(location, true);
    }

    @Nonnull
    public static TextureSupplier registerTexture(@Nonnull String location, boolean prependDomain) {
        if (instance == null) {
            instance = new TextureRegistryClient();
            instance.init();
        }
        return instance.registerTexture(location, prependDomain);
    }

    private TextureRegistry() {
    }

    private static class TextureRegistryClient
    extends TextureRegistryServer {
        @SideOnly(value=Side.CLIENT)
        private Map<String, TextureAtlasSprite> sprites;

        private TextureRegistryClient() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void init() {
            this.sprites = new HashMap<String, TextureAtlasSprite>();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onIconLoad(TextureStitchEvent.Pre event) {
            for (Map.Entry<String, TextureAtlasSprite> entry : this.sprites.entrySet()) {
                entry.setValue(event.getMap().func_174942_a(new ResourceLocation((String)NullHelper.notnull((Object)entry.getKey(), (String)"internal data corruption"))));
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        @Nonnull
        public TextureSupplier registerTexture(@Nonnull String location, boolean prependModID) {
            String keyF;
            String key = location;
            if (prependModID) {
                key = "enderio:" + location;
            }
            if (!this.sprites.containsKey(keyF = key)) {
                this.sprites.put(keyF, null);
            }
            return new TextureSupplier(){

                @Override
                @Nonnull
                public <T> T get(@Nonnull Class<T> clazz) {
                    if (clazz == TextureAtlasSprite.class) {
                        TextureAtlasSprite sprite = (TextureAtlasSprite)sprites.get(keyF);
                        if (sprite != null) {
                            return (T)sprite;
                        }
                        Log.error("Missing texture: " + keyF);
                        return (T)RenderUtil.getMissingSprite();
                    }
                    throw new UnsupportedOperationException("TextureSupplier can only supply TextureAtlasSprite");
                }
            };
        }
    }

    private static class TextureRegistryServer {
        private TextureRegistryServer() {
        }

        protected void init() {
        }

        @Nonnull
        public TextureSupplier registerTexture(@Nonnull String location, boolean prependDomain) {
            return noSupplier;
        }
    }

    public static interface TextureSupplier {
        @Nonnull
        public <T> T get(@Nonnull Class<T> var1);
    }
}

