/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.soul;

import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.spawner.BrokenSpawnerHandler;
import crazypants.enderio.base.recipe.soul.AbstractSoulBinderRecipe;
import crazypants.enderio.base.recipe.spawner.PoweredSpawnerRecipeRegistry;
import crazypants.enderio.util.CapturedMob;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SoulBinderSpawnerRecipe
extends AbstractSoulBinderRecipe {
    @Nonnull
    public static final SoulBinderSpawnerRecipe instance = new SoulBinderSpawnerRecipe();

    public SoulBinderSpawnerRecipe() {
        super(Config.soulBinderBrokenSpawnerRF, Config.soulBinderBrokenSpawnerLevels, "SoulFuserSpawnerRecipe", new ResourceLocation[0]);
    }

    @Override
    @Nonnull
    protected ItemStack getOutputStack(@Nonnull ItemStack input, @Nonnull CapturedMob mobType) {
        return mobType.toStack(ModObject.itemBrokenSpawner.getItemNN(), input.func_77960_j(), 1);
    }

    @Override
    protected boolean isValidInputSoul(@Nonnull CapturedMob mobType) {
        return this.getSupportedSouls().contains((Object)mobType.getEntityName()) && !BrokenSpawnerHandler.isBlackListed(mobType.getEntityName());
    }

    @Override
    @Nonnull
    public ItemStack getInputStack() {
        return new ItemStack(ModObject.itemBrokenSpawner.getItemNN());
    }

    @Override
    @Nonnull
    public ItemStack getOutputStack() {
        return new ItemStack(ModObject.itemBrokenSpawner.getItemNN());
    }

    @Override
    @Nonnull
    public NNList<ResourceLocation> getSupportedSouls() {
        NNList allRegisteredMobNames = EntityUtil.getAllRegisteredMobNames();
        NNList.NNIterator iterator = allRegisteredMobNames.iterator();
        while (iterator.hasNext()) {
            if (!PoweredSpawnerRecipeRegistry.getInstance().isBlackListed((ResourceLocation)iterator.next())) continue;
            iterator.remove();
        }
        return allRegisteredMobNames;
    }
}

