/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.painter;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.util.Prep;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public abstract class AbstractPainterTemplate<T>
implements IMachineRecipe {
    public AbstractPainterTemplate() {
        this.registerTargetsWithTooltipProvider();
    }

    protected abstract void registerTargetsWithTooltipProvider();

    public abstract boolean isValidTarget(@Nonnull ItemStack var1);

    @Nonnull
    protected abstract IMachineRecipe.ResultStack[] produceCompletedResult(@Nonnull ItemStack var1, @Nonnull ItemStack var2);

    public abstract boolean isRecipe(@Nonnull ItemStack var1, @Nonnull ItemStack var2);

    public abstract boolean isPartialRecipe(@Nonnull ItemStack var1, @Nonnull ItemStack var2);

    @Override
    public int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        return RecipeConfig.energyPerTask.get();
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType(@Nonnull NNList<MachineRecipeInput> inputs) {
        return RecipeBonusType.NONE;
    }

    @Nonnull
    public ItemStack getTarget(@Nonnull NNList<MachineRecipeInput> inputs) {
        return MachineRecipeInput.getInputForSlot(0, inputs);
    }

    @Nonnull
    public ItemStack getPaintSource(@Nonnull NNList<MachineRecipeInput> inputs) {
        return MachineRecipeInput.getInputForSlot(1, inputs);
    }

    @Override
    public final boolean isRecipe(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        return this.isRecipe(this.getPaintSource(inputs), this.getTarget(inputs));
    }

    @Override
    @Nonnull
    public final IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        ItemStack target = this.getTarget(inputs);
        ItemStack paintSource = this.getPaintSource(inputs);
        IMachineRecipe.ResultStack[] result = this.produceCompletedResult(paintSource, target);
        this.applyExtraTags(target, paintSource, result);
        return result;
    }

    private void applyExtraTags(@Nonnull ItemStack target, @Nonnull ItemStack paintSource, @Nonnull IMachineRecipe.ResultStack[] result) {
        for (IMachineRecipe.ResultStack resultStack : result) {
            if (!PaintUtil.isPainted(resultStack.item)) continue;
            PaintUtil.setPaintSource(resultStack.item, paintSource);
            if (target.func_77973_b() == resultStack.item.func_77973_b()) continue;
            PaintUtil.setOriginalStack(resultStack.item, target);
        }
    }

    @Nonnull
    public final ItemStack getCompletedResult(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        IMachineRecipe.ResultStack[] result = this.produceCompletedResult(paintSource, target);
        this.applyExtraTags(target, paintSource, result);
        return result.length > 0 ? result[0].item : Prep.getEmpty();
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "painter";
    }

    @Override
    @Nonnull
    public String getUid() {
        return this.getClass().getCanonicalName() + "@" + Integer.toHexString(this.hashCode());
    }

    public int getQuantityConsumed(@Nonnull MachineRecipeInput input) {
        return input.slotNumber == 0 ? 1 : 0;
    }

    @Override
    @Nonnull
    public List<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        MachineRecipeInput consume = null;
        for (MachineRecipeInput input : inputs) {
            if (input == null || input.slotNumber != 0 || !Prep.isValid(input.item)) continue;
            ItemStack consumed = input.item.func_77946_l();
            consumed.func_190920_e(1);
            consume = new MachineRecipeInput(input.slotNumber, consumed);
        }
        if (consume != null) {
            return Collections.singletonList(consume);
        }
        return Collections.emptyList();
    }

    @Override
    public float getExperienceForOutput(@Nonnull ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput input) {
        return this.isValidInput(input);
    }

    protected abstract boolean isValidInput(@Nonnull MachineRecipeInput var1);
}

