/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.forge;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.power.ILegacyPowerReceiver;
import crazypants.enderio.base.power.ILegacyPoweredTile;
import crazypants.enderio.base.power.IPowerApiAdapter;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.ItemPowerCapabilityBackend;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.power.forge.InternalPoweredItemWrapper;
import crazypants.enderio.base.power.forge.InternalPoweredTileWrapper;
import crazypants.enderio.base.power.forge.InternalRecieverTileWrapper;
import crazypants.enderio.base.power.forge.PowerInterfaceForge;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ForgeAdapter
implements IPowerApiAdapter {
    @Nonnull
    private final Capability<IEnergyStorage> ENERGY_HANDLER;
    private static final ResourceLocation KEY = new ResourceLocation("enderio", "forgeadapter");

    public static void capRegistered(@Nonnull Capability<IEnergyStorage> cap) {
        PowerHandlerUtil.addAdapter(new ForgeAdapter(cap));
        MinecraftForge.EVENT_BUS.register(ForgeAdapter.class);
        ItemPowerCapabilityBackend.register(new InternalPoweredItemWrapper.PoweredItemCapabilityProvider());
        Log.info("Forge Energy integration loaded");
    }

    private ForgeAdapter(@Nonnull Capability<IEnergyStorage> cap) {
        this.ENERGY_HANDLER = cap;
    }

    @Override
    public IPowerInterface getPowerInterface(@Nullable ICapabilityProvider provider, @Nullable EnumFacing side) {
        IEnergyStorage cap;
        if (provider != null && (cap = this.getCapability(provider, side)) != null) {
            return new PowerInterfaceForge(provider, cap);
        }
        return null;
    }

    @Override
    public IEnergyStorage getCapability(@Nullable ICapabilityProvider provider, @Nullable EnumFacing side) {
        if (provider != null) {
            Object capability = provider.getCapability(this.ENERGY_HANDLER, side);
            if (capability instanceof IEnergyStorage) {
                return (IEnergyStorage)capability;
            }
            if (capability != null) {
                throw new RuntimeException("'" + provider + "' returned '" + capability.getClass() + "' instead of an IEnergyStorage. This is a bug in THAT OTHER MOD, NOT Ender IO.");
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<TileEntity> evt) {
        if (evt.getCapabilities().containsKey(KEY)) {
            return;
        }
        TileEntity te = (TileEntity)evt.getObject();
        if (te instanceof ILegacyPowerReceiver) {
            evt.addCapability(KEY, (ICapabilityProvider)new InternalRecieverTileWrapper.RecieverTileCapabilityProvider((ILegacyPowerReceiver)te));
        } else if (te instanceof ILegacyPoweredTile) {
            evt.addCapability(KEY, (ICapabilityProvider)new InternalPoweredTileWrapper.PoweredTileCapabilityProvider((ILegacyPoweredTile)te));
        }
    }
}

