/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.render;

import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.base.block.AbstractMachineBlock;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.render.PaintedBlockAccessWrapper;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.property.IOMode;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.base.render.util.QuadCollector;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class MachineRenderMapper
implements IRenderMapper.IBlockRenderMapper,
IRenderMapper.IItemRenderMapper.IItemStateMapper {
    protected final EnumRenderPart body;

    public MachineRenderMapper(EnumRenderPart body) {
        this.body = body;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        TileEntity tileEntity = this.getTileEntity(state, pos);
        Block block = state.func_177230_c();
        if (tileEntity instanceof AbstractMachineEntity && block instanceof AbstractMachineBlock) {
            return this.render(state.getState(), world, pos, blockLayer, (AbstractMachineEntity)tileEntity, (AbstractMachineBlock)block);
        }
        return null;
    }

    private TileEntity getTileEntity(@Nonnull IBlockStateWrapper state, @Nonnull BlockPos pos) {
        TileEntity te;
        IBlockAccess world = state.getWorld();
        if (world instanceof PaintedBlockAccessWrapper && (te = ((PaintedBlockAccessWrapper)world).getRealTileEntity(pos)) instanceof AbstractMachineEntity) {
            return te;
        }
        return state.getTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    protected List<IBlockState> render(IBlockState state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, AbstractMachineEntity tileEntity, AbstractMachineBlock<?> block) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        EnumFacing facing = tileEntity.getFacing();
        boolean active = tileEntity.isActive();
        if (this.body != null) {
            states.add(ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)this.body.rotate(facing))));
        }
        if (active) {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON.rotate(facing))));
        } else {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT.rotate(facing))));
        }
        return states;
    }

    @SideOnly(value=Side.CLIENT)
    protected EnumMap<EnumFacing, IOMode.EnumIOMode> renderIO(@Nonnull AbstractMachineEntity tileEntity, @Nonnull AbstractMachineBlock<?> block) {
        EnumMap<EnumFacing, IOMode.EnumIOMode> result = new EnumMap<EnumFacing, IOMode.EnumIOMode>(EnumFacing.class);
        for (EnumFacing face : EnumFacing.values()) {
            IoMode ioMode = tileEntity.getIoMode(face);
            if (ioMode == IoMode.NONE) continue;
            IOMode.EnumIOMode iOMode = block.mapIOMode(ioMode, face);
            result.put(face, iOMode);
        }
        return result.isEmpty() ? null : result;
    }

    @SideOnly(value=Side.CLIENT)
    protected EnumMap<EnumFacing, IOMode.EnumIOMode> renderPaintIO(@Nonnull AbstractMachineEntity tileEntity, @Nonnull AbstractMachineBlock<?> block) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public List<Pair<IBlockState, ItemStack>> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ItemQuadCollector itemQuadCollector) {
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        EnumRenderPart body_nullchecked = this.body;
        if (body_nullchecked != null) {
            states.add(Pair.of((Object)ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)body_nullchecked)), (Object)stack));
        }
        states.add(Pair.of((Object)block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT)), (Object)stack));
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, boolean isPainted) {
        TileEntity tileEntity = state.getTileEntity();
        Block block = state.func_177230_c();
        if (tileEntity instanceof AbstractMachineEntity && block instanceof AbstractMachineBlock) {
            if (isPainted) {
                return this.renderPaintIO((AbstractMachineEntity)tileEntity, (AbstractMachineBlock)block);
            }
            return this.renderIO((AbstractMachineEntity)tileEntity, (AbstractMachineBlock)block);
        }
        return null;
    }
}

