/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.padding;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.item.darksteel.upgrade.padding.PaddingUpgrade;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class PaddingHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (NullHelper.untrust((Object)player) != null && PaddingUpgrade.INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD))) {
            event.setResultSound(PaddingHandler.make((ISound)NullHelper.first((Object[])new ISound[]{event.getResultSound(), event.getSound()})));
        }
    }

    private static ISound make(@Nonnull ISound parent) {
        if (parent instanceof MutedSound) {
            return parent;
        }
        if (parent instanceof ITickableSound) {
            return new TickableMutedSound((ITickableSound)parent);
        }
        return new MutedSound(parent);
    }

    private static class TickableMutedSound
    extends MutedSound
    implements ITickableSound {
        public TickableMutedSound(@Nonnull ITickableSound parent) {
            super((ISound)parent);
        }

        public void func_73660_a() {
            ((ITickableSound)this.parent).func_73660_a();
        }

        public boolean func_147667_k() {
            return ((ITickableSound)this.parent).func_147667_k();
        }
    }

    private static class MutedSound
    implements ISound {
        @Nonnull
        protected final ISound parent;

        public MutedSound(@Nonnull ISound parent) {
            this.parent = parent;
        }

        @Nonnull
        public ResourceLocation func_147650_b() {
            return this.parent.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(@Nonnull SoundHandler handler) {
            return this.parent.func_184366_a(handler);
        }

        @Nonnull
        public Sound func_184364_b() {
            return this.parent.func_184364_b();
        }

        @Nonnull
        public SoundCategory func_184365_d() {
            return this.parent.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.parent.func_147657_c();
        }

        public int func_147652_d() {
            return this.parent.func_147652_d();
        }

        public float func_147653_e() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (NullHelper.untrust((Object)player) != null && PaddingUpgrade.INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD))) {
                double distanceSq = player.func_180425_c().func_177954_c((double)this.func_147649_g(), (double)this.func_147654_h(), (double)this.func_147651_i());
                double cutoffDistance = DarkSteelConfig.cutoffDistance.get();
                float volume = Math.min(0.1f, Math.min(1.0f, (float)(distanceSq / (cutoffDistance * cutoffDistance))));
                return this.parent.func_147653_e() * volume;
            }
            return this.parent.func_147653_e();
        }

        public float func_147655_f() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (NullHelper.untrust((Object)player) != null && PaddingUpgrade.INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD))) {
                return this.parent.func_147655_f() * DarkSteelConfig.pitchAdjust.get().floatValue();
            }
            return this.parent.func_147655_f();
        }

        public float func_147649_g() {
            return this.parent.func_147649_g();
        }

        public float func_147654_h() {
            return this.parent.func_147654_h();
        }

        public float func_147651_i() {
            return this.parent.func_147651_i();
        }

        @Nonnull
        public ISound.AttenuationType func_147656_j() {
            return this.parent.func_147656_j();
        }
    }
}

