/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.OreDictionaryHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.harvesters.AxeHarvestingTarget;
import crazypants.enderio.base.farming.harvesters.TreeHarvester;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelPickaxe;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.hoe.HoeUpgrade;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.Prep;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemDarkSteelAxe
extends ItemAxe
implements IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware {
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();
    @Nonnull
    private final IEquipmentData data;

    public static boolean isEquipped(EntityPlayer player) {
        return player != null && player.func_184614_ca().func_77973_b() == ModObject.itemDarkSteelAxe.getItem();
    }

    public static boolean isPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelAxe.getStoredPower(player) > requiredPower;
    }

    public static boolean isPowered(EntityPlayer player, IValue<Integer> requiredPower) {
        return ItemDarkSteelAxe.getStoredPower(player) > requiredPower.get();
    }

    public static int getStoredPower(EntityPlayer player) {
        return EnergyUpgradeManager.getEnergyStored(player.func_184614_ca());
    }

    @Nonnull
    public static ItemDarkSteelAxe createEndSteel(@Nonnull IModObject modObject) {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe(modObject, EquipmentData.END_STEEL);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    @Nonnull
    public static ItemDarkSteelAxe createDarkSteel(@Nonnull IModObject modObject) {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe(modObject, EquipmentData.DARK_STEEL);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    @Nonnull
    public static ItemDarkSteelAxe createStellarAlloy(@Nonnull IModObject modObject) {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe(modObject, EquipmentData.STELLAR_ALLOY);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemDarkSteelAxe(@Nonnull IModObject modObject, @Nonnull IEquipmentData data) {
        super(data.getToolMaterial(), 8.0f, -3.0f);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.data = data;
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            HoeUpgrade.INSTANCE.addToItem(is, this);
            list.add((Object)is);
        }
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState bs;
        Block block;
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af() && EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack) && FarmersRegistry.isLog(block = (bs = player.field_70170_p.func_180495_p(pos)).func_177230_c())) {
            int powerStored = EnergyUpgradeManager.getEnergyStored(itemstack);
            HarvestResult res = new HarvestResult();
            AxeHarvestingTarget target = new AxeHarvestingTarget(bs, pos);
            TreeHarvester.harvest(player.field_70170_p, pos, res, target);
            NNList sortedTargets = new NNList(res.getHarvestedBlocks());
            this.harvestComparator.refPoint = pos;
            Collections.sort(sortedTargets, this.harvestComparator);
            int maxBlocks = DarkSteelConfig.axePowerUsePerDamagePointMultiHarvest.get() == 0 ? sortedTargets.size() : powerStored / DarkSteelConfig.axePowerUsePerDamagePointMultiHarvest.get();
            int numUsedPower = 0;
            for (int i = 0; numUsedPower < maxBlocks && i < sortedTargets.size(); ++i) {
                if (!this.doMultiHarvest(player, player.field_70170_p, (BlockPos)sortedTargets.get(i), block)) continue;
                ++numUsedPower;
            }
            return numUsedPower != 0;
        }
        return false;
    }

    private boolean doMultiHarvest(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos bc, @Nonnull Block refBlock) {
        IBlockState bs = world.func_180495_p(bc);
        Block block = bs.func_177230_c();
        bs = bs.func_185899_b((IBlockAccess)world, bc);
        ItemStack held = player.func_184614_ca();
        NNList drops = new NNList();
        block.getDrops((NonNullList)drops, (IBlockAccess)world, bc, bs, 0);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)bc, (IBlockState)bs, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)held), (float)1.0f, (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)held) != 0 ? 1 : 0) != 0, (EntityPlayer)player);
        world.func_175698_g(bc);
        boolean usedPower = false;
        for (ItemStack stack : drops) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, stack.func_77946_l()));
            if (block != refBlock) continue;
            EnergyUpgradeManager.extractEnergy(player.func_184614_ca(), (IDarkSteelItem)this, DarkSteelConfig.axePowerUsePerDamagePointMultiHarvest, false);
            usedPower = true;
        }
        return usedPower;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if (ItemDarkSteelAxe.isEquipped(evt.getEntityPlayer())) {
            if (evt.getEntityPlayer().func_70093_af() && ItemDarkSteelAxe.isPowered(evt.getEntityPlayer(), DarkSteelConfig.axePowerUsePerDamagePointMultiHarvest) && FarmersRegistry.isLog(evt.getState().func_177230_c())) {
                evt.setNewSpeed(evt.getOriginalSpeed() / DarkSteelConfig.axeSpeedPenaltyMultiHarvest.get().floatValue());
            } else if (evt.getState().func_185904_a() == Material.field_151584_j) {
                evt.setNewSpeed(6.0f);
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        int hook;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_175151_a(pos, side, stack) && HoeUpgrade.INSTANCE.hasUpgrade(stack) && (hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos)) == 0) {
            IBlockState iblockstate = world.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (side != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
                if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                    this.setBlock(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                    return EnumActionResult.SUCCESS;
                }
                if (block == Blocks.field_150346_d) {
                    switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                        case DIRT: {
                            this.setBlock(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                            return EnumActionResult.SUCCESS;
                        }
                        case COARSE_DIRT: {
                            this.setBlock(stack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                            return EnumActionResult.SUCCESS;
                        }
                    }
                }
            }
        }
        if (world.field_72995_K && DarkSteelConfig.rightClickPlaceEnabled_axe.get().booleanValue()) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, pos, side, hand, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    public void setDamage(@Nonnull ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * DarkSteelConfig.axePowerUsePerDamagePoint.get())) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(@Nonnull ItemStack stack, int amount) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem();
            return true;
        }
        return false;
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        if (ItemDarkSteelPickaxe.isToolEffective(state, stack)) {
            if (DarkSteelConfig.axePowerUsePerDamagePoint.get() <= 0 ? EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack) : EnergyUpgradeManager.getEnergyStored(stack) > 0) {
                return this.field_77862_b.func_77998_b() + DarkSteelConfig.axeEfficiencyBoostWhenPowered.get().floatValue();
            }
            return this.field_77862_b.func_77998_b();
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(Lang.AXE_MULTIHARVEST.get());
            list.add(Lang.AXE_POWERED.get(TextFormatting.WHITE, DarkSteelConfig.axeEfficiencyBoostWhenPowered.get()));
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged || Prep.isInvalid(oldStack) || Prep.isInvalid(newStack) || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean isAxe() {
        return true;
    }

    protected void setBlock(ItemStack stack, @Nonnull EntityPlayer player, World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    @Override
    public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return upgrade == HoeUpgrade.INSTANCE;
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return this.data;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_AXE_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_AXE_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_AXE_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_AXE_ABSORPTION_RATIO;
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockPos> {
        BlockPos refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockPos arg0, BlockPos arg1) {
            double d1 = this.refPoint.func_177954_c((double)arg0.func_177958_n(), (double)arg0.func_177956_o(), (double)arg0.func_177952_p());
            double d2 = this.refPoint.func_177954_c((double)arg1.func_177958_n(), (double)arg1.func_177956_o(), (double)arg1.func_177952_p());
            return MultiHarvestComparator.compare(d1, d2);
        }

        public static int compare(double x, double y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

