/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.InfinityConfig;
import crazypants.enderio.base.gui.BlockSceneRenderer;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.material.Material;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class InfinityRecipeCategory
implements IRecipeCategory<InfinityRecipeWrapper> {
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private static final String UUID = "infinityPowder";
    private BlockSceneRenderer bsr;
    private IRecipeLayout recipeLayout;

    public static void registerExtras(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)new ItemStack(Blocks.field_150357_h, 1, 0), new String[]{UUID});
        registry.addRecipeCatalyst((Object)new ItemStack(Items.field_151033_d, 1, 0), new String[]{UUID});
        long start = System.nanoTime();
        ArrayList<InfinityRecipeWrapper> result = new ArrayList<InfinityRecipeWrapper>();
        if (InfinityConfig.inWorldCraftingEnabled.get().booleanValue()) {
            result.add(new InfinityRecipeWrapper());
        }
        long end = System.nanoTime();
        registry.addRecipes(result, UUID);
        Log.info(String.format("InfinityRecipeCategory: Added %d infinity recipe(s) to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9));
    }

    public InfinityRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("infinity");
        this.background = guiHelper.createDrawable(backgroundLocation, 0, 0, 128, 64);
    }

    @Nonnull
    public String getUid() {
        return UUID;
    }

    @Nonnull
    public String getTitle() {
        return Material.POWDER_INFINITY.getStack().func_82833_r();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull InfinityRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 85, 30);
        itemStacks.set(ingredients);
        this.recipeLayout = recipeLayout;
        this.bsr = new BlockSceneRenderer((NNList<Pair<BlockPos, IBlockState>>)new NNList((Object[])new Pair[]{Pair.of((Object)new BlockPos(0, 0, 0), (Object)Blocks.field_150357_h.func_176223_P()), Pair.of((Object)new BlockPos(0, 1, 0), (Object)Blocks.field_150480_ab.func_176223_P())}));
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        int x = ((RecipeLayout)this.recipeLayout).getPosX() + 15;
        int y = 20 + ((RecipeLayout)this.recipeLayout).getPosY();
        int w = 26;
        int h = 50;
        GlStateManager.func_179094_E();
        this.bsr.drawScreen(x, y, w, h);
        GlStateManager.func_179121_F();
        String text = "<" + (int)(InfinityConfig.dropChance.get().floatValue() * 100.0f) + "%";
        int stringWidth = minecraft.field_71466_p.func_78256_a(text);
        minecraft.field_71466_p.func_175065_a(text, (float)(59 - stringWidth / 2), 36.0f, 0xFFFFFF, false);
        if (!InfinityConfig.enableInAllDimensions.get().booleanValue()) {
            minecraft.field_71466_p.func_78276_b(Lang.GUI_INFINTY_RECIPE_DIMENSIONS.get(), 59, 66, ColorUtil.getRGB((Color)Color.GRAY));
        }
    }

    @Nonnull
    public String getModName() {
        return "enderio";
    }

    public static class InfinityRecipeWrapper
    implements IRecipeWrapper {
        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setOutput(ItemStack.class, (Object)Material.POWDER_INFINITY.getStack());
        }
    }
}

