/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.client.gui.widget.GhostSlot;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mezz.jei.api.gui.IGhostIngredientHandler$Target", modid="jei")
public class GhostSlotTarget<I>
implements IGhostIngredientHandler.Target<I> {
    @Nonnull
    private IFilter filter;
    private int x;
    private int y;
    private int slotX;
    private int slotY;
    private int slotIndex;
    @Nonnull
    private AbstractFilterGui gui;
    private GhostSlot slot;

    public GhostSlotTarget(@Nonnull IFilter filter, @Nonnull GhostSlot slot, int x, int y, @Nonnull AbstractFilterGui gui) {
        this.filter = filter;
        this.slotIndex = slot.getSlot();
        this.slotX = slot.getX();
        this.slotY = slot.getY();
        this.x = x;
        this.y = y;
        this.gui = gui;
        this.slotIndex = slot.getSlot();
        this.slot = slot;
    }

    public GhostSlotTarget(@Nonnull IFilter filter, int slot, int x, int y, int slotX, int slotY, @Nonnull AbstractFilterGui gui) {
        this.filter = filter;
        this.slotIndex = slot;
        this.x = x;
        this.y = y;
        this.gui = gui;
        this.slotX = slotX;
        this.slotY = slotY;
    }

    @Nonnull
    public Rectangle getArea() {
        return new Rectangle(this.slotX + this.x, this.slotY + this.y, 16, 16);
    }

    public void accept(@Nullable I ingredient) {
        if (ingredient instanceof ItemStack) {
            if (this.slot != null) {
                this.slot.putStack((ItemStack)ingredient, 1);
                return;
            }
            this.filter.setInventorySlotContents(this.slotIndex, (ItemStack)ingredient);
            this.gui.sendFilterChange();
        }
    }
}

