/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.DamageModeIconHolder;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ItemFilter;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.GhostSlotTarget;
import crazypants.enderio.base.lang.Lang;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class BasicItemFilterGui
extends AbstractFilterGui {
    private static final int ID_WHITELIST = FilterGuiUtil.nextButtonId();
    private static final int ID_NBT = FilterGuiUtil.nextButtonId();
    private static final int ID_META = FilterGuiUtil.nextButtonId();
    private static final int ID_ORE_DICT = FilterGuiUtil.nextButtonId();
    private static final int ID_STICKY = FilterGuiUtil.nextButtonId();
    private static final int ID_DAMAGE = FilterGuiUtil.nextButtonId();
    private final ToggleButton useMetaB;
    private final ToggleButton useNbtB;
    private final IconButton whiteListB;
    private final ToggleButton useOreDictB;
    private final ToggleButton stickyB;
    private final CycleButton<DamageModeIconHolder> damageB;
    final boolean isAdvanced;
    final boolean isLimited;
    final boolean isBig;
    @Nonnull
    private final ItemFilter filter;
    private int xOffset;
    private int yOffset;

    public BasicItemFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IItemFilter filter) {
        this(playerInv, filterContainer, 13, 34, te, filter);
    }

    public BasicItemFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, int xOffset, int yOffset, TileEntity te, @Nonnull IItemFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn, "basic_item_filter", "advanced_item_filter", "big_item_filter");
        int butLeft;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.filter = (ItemFilter)filterIn;
        this.isAdvanced = this.filter.isAdvanced();
        this.isLimited = this.filter.isLimited();
        this.isBig = this.filter.isBig();
        int x = butLeft = xOffset + 98;
        int y = yOffset + 1;
        if (this.isBig) {
            y = 13;
            x = this.isAdvanced ? x - 53 : x + 27;
        }
        this.whiteListB = new IconButton((IGuiScreen)this, ID_WHITELIST, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        this.useMetaB = new ToggleButton((IGuiScreen)this, ID_META, x += 20, y, (IWidgetIcon)IconEIO.FILTER_META_OFF, (IWidgetIcon)IconEIO.FILTER_META);
        this.useMetaB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_MATCH_META.get()});
        this.useMetaB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_IGNORE_META.get()});
        this.useMetaB.setPaintSelectedBorder(false);
        this.stickyB = new ToggleButton((IGuiScreen)this, ID_STICKY, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        this.stickyB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_ENABLED.get(), Lang.GUI_ITEM_FILTER_STICKY_ENABLED_2.get()});
        this.stickyB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_DISABLED.get()});
        this.stickyB.setPaintSelectedBorder(false);
        if (!this.isBig) {
            y += 20;
            x = butLeft;
        } else {
            x += 20;
        }
        this.useOreDictB = new ToggleButton((IGuiScreen)this, ID_ORE_DICT, x, y, (IWidgetIcon)IconEIO.FILTER_ORE_DICT_OFF, (IWidgetIcon)IconEIO.FILTER_ORE_DICT);
        this.useOreDictB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_ORE_DIC_ENABLED.get()});
        this.useOreDictB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_ORE_DIC_DISABLED.get()});
        this.useOreDictB.setPaintSelectedBorder(false);
        this.useNbtB = new ToggleButton((IGuiScreen)this, ID_NBT, x += 20, y, (IWidgetIcon)IconEIO.FILTER_NBT_OFF, (IWidgetIcon)IconEIO.FILTER_NBT);
        this.useNbtB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_MATCH_NBT.get()});
        this.useNbtB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_IGNORE_NBT.get()});
        this.useNbtB.setPaintSelectedBorder(false);
        this.damageB = new CycleButton((IGuiScreen)this, ID_DAMAGE, x += 20, y, DamageModeIconHolder.class);
    }

    public void createFilterSlots() {
        this.filter.createGhostSlots((NNList<GhostSlot>)this.getGhostSlotHandler().getGhostSlots(), this.xOffset + 1, this.yOffset + 1, new Runnable(){

            @Override
            public void run() {
                BasicItemFilterGui.this.sendFilterChange();
            }
        });
    }

    @Override
    public void func_73866_w_() {
        this.createFilterSlots();
        super.func_73866_w_();
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        ItemFilter activeFilter = this.filter;
        if (this.isAdvanced) {
            this.useNbtB.onGuiInit();
            this.useNbtB.setSelected(activeFilter.isMatchNBT());
            this.useOreDictB.onGuiInit();
            this.useOreDictB.setSelected(activeFilter.isUseOreDict());
            if (this.isStickyModeAvailable) {
                this.stickyB.onGuiInit();
                this.stickyB.setSelected(activeFilter.isSticky());
            }
            this.damageB.onGuiInit();
            this.damageB.setMode((Enum)DamageModeIconHolder.getFromMode(activeFilter.getDamageMode()));
        }
        this.useMetaB.onGuiInit();
        this.useMetaB.setSelected(activeFilter.isMatchMeta());
        if (!this.isLimited) {
            this.whiteListB.onGuiInit();
            if (activeFilter.isBlacklist()) {
                this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
                this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_BLACKLIST.get()});
            } else {
                this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
                this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
            }
        }
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (guiButton.field_146127_k == ID_META) {
            this.filter.setMatchMeta(this.useMetaB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_NBT) {
            this.filter.setMatchNBT(this.useNbtB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_STICKY) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_ORE_DICT) {
            this.filter.setUseOreDict(this.useOreDictB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_DAMAGE) {
            this.filter.setDamageMode(((DamageModeIconHolder)this.damageB.getMode()).getMode());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_WHITELIST) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    @Override
    public void bindGuiTexture() {
        super.bindGuiTexture(this.isBig ? 2 : (this.isAdvanced ? 1 : 0));
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        if (this.filter.isBig()) {
            return this.filter.isAdvanced() ? Lang.GUI_BIG_ADVANCED_ITEM_FILTER.get() : Lang.GUI_BIG_ITEM_FILTER.get();
        }
        if (this.filter.isLimited()) {
            return Lang.GUI_LIMITED_ITEM_FILTER.get();
        }
        if (this.filter.isAdvanced()) {
            return Lang.GUI_ADVANCED_ITEM_FILTER.get();
        }
        return Lang.GUI_BASIC_ITEM_FILTER.get();
    }

    @Override
    @Nonnull
    public List<GhostSlotTarget<?>> getGhostTargets() {
        ArrayList targets = new ArrayList();
        for (GhostSlot slot : this.getGhostSlotHandler().getGhostSlots()) {
            targets.add(new GhostSlotTarget(this.filter, slot, this.getGuiLeft(), this.getGuiTop(), this));
        }
        return targets;
    }
}

