/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.registry;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.farmers.TreeFarmer;
import crazypants.enderio.base.farming.registry.Registry;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.EventPriority;

public class Commune
implements IFarmerJoe {
    @Nonnull
    public static final Commune instance = new Commune();
    @Nonnull
    static NNList<ItemStack> disableTrees = new NNList();

    private Commune() {
    }

    @Override
    public boolean canHarvest(final @Nonnull IFarmer farm, final @Nonnull BlockPos bc, final @Nonnull IBlockState state) {
        return Registry.foreach(new Registry.Callback<Boolean>(){

            @Override
            public Boolean run(@Nonnull IFarmerJoe joe) {
                return joe.canHarvest(farm, bc, state) ? Boolean.TRUE : null;
            }
        }) != null;
    }

    @Override
    public IHarvestResult harvestBlock(final @Nonnull IFarmer farm, final @Nonnull BlockPos bc, final @Nonnull IBlockState state) {
        return Registry.foreach(new Registry.Callback<IHarvestResult>(){

            @Override
            public IHarvestResult run(@Nonnull IFarmerJoe joe) {
                return !Commune.this.ignoreTreeHarvest(farm, bc, joe) && joe.canHarvest(farm, bc, state) ? joe.harvestBlock(farm, bc, state) : null;
            }
        });
    }

    @Override
    @Deprecated
    public boolean prepareBlock(final @Nonnull IFarmer farm, final @Nonnull BlockPos bc, final @Nonnull IBlockState state) {
        return Registry.foreach(new Registry.Callback<Boolean>(){

            @Override
            public Boolean run(@Nonnull IFarmerJoe joe) {
                return joe.prepareBlock(farm, bc, state) ? Boolean.TRUE : null;
            }
        }) != null;
    }

    @Override
    public IFarmerJoe.Result tryPrepareBlock(final @Nonnull IFarmer farm, final @Nonnull BlockPos pos, final @Nonnull IBlockState state) {
        IFarmerJoe.Result result = Registry.foreach(new Registry.Callback<IFarmerJoe.Result>(){

            @Override
            public IFarmerJoe.Result run(@Nonnull IFarmerJoe joe) {
                IFarmerJoe.Result result2 = joe.tryPrepareBlock(farm, pos, state);
                return result2 != IFarmerJoe.Result.NEXT ? result2 : null;
            }
        });
        return result != null ? result : IFarmerJoe.Result.NEXT;
    }

    @Override
    public boolean canPlant(final @Nonnull ItemStack stack) {
        return Registry.foreach(new Registry.Callback<Boolean>(){

            @Override
            public Boolean run(@Nonnull IFarmerJoe joe) {
                return joe.canPlant(stack) ? Boolean.TRUE : null;
            }
        }) != null;
    }

    private boolean ignoreTreeHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, IFarmerJoe joe) {
        if (!(joe instanceof TreeFarmer)) {
            return false;
        }
        ItemStack stack = farm.getSeedTypeInSuppliesFor(bc);
        if (Prep.isInvalid(stack)) {
            return false;
        }
        for (ItemStack disableTreeStack : disableTrees) {
            if (!disableTreeStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public IFarmerJoe setRegistryName(ResourceLocation name) {
        return null;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return null;
    }

    public Class<IFarmerJoe> getRegistryType() {
        return null;
    }

    @Override
    @Nonnull
    public EventPriority getPriority() {
        return EventPriority.HIGHEST;
    }
}

