/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.Data;
import crazypants.enderio.base.config.recipes.xml.Scaler;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class IndexedScaler
extends Scaler {
    private float step = 1.0f;
    private List<Data> data = new NNList();

    @Override
    public Scaler readResolve() throws InvalidRecipeConfigException, XMLStreamException {
        try {
            if (this.step <= 0.0f) {
                throw new InvalidRecipeConfigException("'step' is invalid");
            }
            boolean valid = !this.data.isEmpty();
            float[] dataArray = new float[this.data.size()];
            for (int i = 0; i < this.data.size(); ++i) {
                if (!(valid &= this.data.get(i).isValid())) continue;
                dataArray[i] = this.data.get(i).getValue();
            }
            if (!valid) {
                throw new InvalidRecipeConfigException("no <data>");
            }
            this.scaler = new crazypants.enderio.base.capacitor.IndexedScaler(this.step, dataArray);
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <indexed>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }

    @Override
    public boolean isValid() {
        return this.scaler != null;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("step".equals(name)) {
            this.step = Float.parseFloat(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("data".equals(name)) {
            this.data.add(factory.read(new Data(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

