/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.factory.AbstractValue;
import crazypants.enderio.base.config.factory.ByteBufHelper;
import crazypants.enderio.base.config.factory.IValueFactory;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class FluidValue
extends AbstractValue<Fluid> {
    @Nonnull
    private static final Fluid defaultFluidPlaceholder = new Fluid("", null, null);
    @Nonnull
    private final String defaultValueName;
    private Fluid defaultFluid = null;

    protected FluidValue(@Nonnull IValueFactory owner, @Nonnull String section, @Nonnull String keyname, @Nonnull String defaultValue, @Nonnull String text) {
        super(owner, section, keyname, defaultFluidPlaceholder, text);
        this.defaultValueName = defaultValue;
    }

    @Override
    @Nonnull
    public Fluid get() {
        if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            return (Fluid)this.defaultValue;
        }
        if (this.defaultFluid == null) {
            this.defaultFluid = FluidRegistry.getFluid((String)this.defaultValueName);
        }
        if (this.value == null || this.valueGeneration != this.owner.getGeneration()) {
            if (this.owner.getServerConfig() != null && this.owner.getServerConfig().containsKey(this.keyname)) {
                this.value = FluidRegistry.getFluid((String)((String)this.owner.getServerConfig().get(this.keyname)));
            } else {
                this.value = FluidRegistry.getFluid((String)this.getString());
                if (!this.owner.isInInit() && this.owner.getConfig().hasChanged()) {
                    this.owner.getConfig().save();
                }
            }
            this.valueGeneration = this.owner.getGeneration();
        }
        return (Fluid)NullHelper.first((Object[])new Fluid[]{(Fluid)this.value, this.defaultFluid, (Fluid)this.defaultValue});
    }

    @Nullable
    private String getString() {
        Property prop = this.owner.getConfig().get(this.section, this.keyname, this.defaultValueName);
        prop.setLanguageKey(this.keyname);
        prop.setValidationPattern(null);
        prop.setComment(this.getText() + " [default: " + this.defaultValueName + "]");
        prop.setRequiresMcRestart(this.isStartup);
        return prop.getString();
    }

    @Override
    @Nullable
    protected Fluid makeValue() {
        this.getString();
        return null;
    }

    @Override
    protected ByteBufHelper getDataType() {
        return ByteBufHelper.STRING127;
    }

    @Override
    public void save(ByteBuf buf) {
        ByteBufHelper.STRING127.saveValue(buf, this.keyname);
        ByteBufHelper dataType = this.getDataType();
        buf.writeByte(dataType.ordinal());
        dataType.saveValue(buf, NullHelper.first((Object[])new String[]{FluidRegistry.getFluidName((Fluid)this.get()), this.defaultValueName}));
    }
}

