/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config;

import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.ConfigElementEio;
import crazypants.enderio.base.lang.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class GuiConfigFactoryEIO
extends GuiConfig {
    public GuiConfigFactoryEIO(GuiScreen parentScreen) {
        super(parentScreen, GuiConfigFactoryEIO.getConfigElements(parentScreen), "enderio", false, false, Lang.CONFIG_TITLE.get());
    }

    private static List<IConfigElement> getConfigElements(GuiScreen parent) {
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        List modList = Loader.instance().getModList();
        for (ModContainer modContainer : modList) {
            Configuration configuration;
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon) || (configuration = ((IEnderIOAddon)mod).getConfiguration()) == null) continue;
            ArrayList<ConfigElementEio> list = new ArrayList<ConfigElementEio>();
            for (String section : configuration.getCategoryNames()) {
                ConfigCategory category = configuration.getCategory(section);
                category.setLanguageKey(EnderIO.lang.addPrefix("config." + category.getQualifiedName()));
                if (category.isChild()) continue;
                list.add(new ConfigElementEio(category));
            }
            result.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(modContainer.getName(), EnderIO.lang.addPrefix("config.title." + modContainer.getModId()), list));
        }
        return result;
    }
}

