/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config;

import com.enderio.core.common.event.ConfigFileChangedEvent;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.PacketConfigSync;
import crazypants.enderio.base.config.config.BaseConfig;
import crazypants.enderio.base.network.PacketHandler;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class Config {
    public static Configuration config;
    @Nonnull
    public static final Section sectionPower;
    @Nonnull
    public static final Section sectionItems;
    @Nonnull
    public static final Section sectionAnchor;
    @Nonnull
    public static final Section sectionStaff;
    @Nonnull
    public static final Section sectionRod;
    @Nonnull
    public static final Section sectionAdvanced;
    @Nonnull
    public static final Section sectionFluid;
    @Nonnull
    public static final Section sectionSoulBinder;
    @Nonnull
    public static final Section sectionSoulVial;
    @Nonnull
    public static final Section sectionMisc;
    @Nonnull
    public static final Section sectionHoes;
    public static final int DEFAULT_CONDUIT_PIXELS = 3;
    public static final float EXPLOSION_RESISTANT = 1200.0f;
    public static int conduitPixels;
    public static File configDirectory;
    public static int travelAnchorMaximumDistance;
    public static int travelAnchorCooldown;
    public static boolean travelAnchorSneak;
    public static boolean travelAnchorSkipWarning;
    public static int travelStaffMaximumDistance;
    public static float travelStaffPowerPerBlockRF;
    public static int travelStaffMaxBlinkDistance;
    public static int travelStaffBlinkPauseTicks;
    public static boolean travelStaffBlinkEnabled;
    public static boolean travelStaffBlinkThroughSolidBlocksEnabled;
    public static boolean travelStaffBlinkThroughClearBlocksEnabled;
    public static boolean travelStaffBlinkThroughUnbreakableBlocksEnabled;
    public static String[] travelStaffBlinkBlackList;
    public static boolean travelStaffOffhandBlinkEnabled;
    public static boolean travelStaffOffhandTravelEnabled;
    public static boolean travelStaffOffhandShowsTravelTargets;
    public static float travelAnchorZoomScale;
    public static int hootchPowerPerCycleRF;
    public static int hootchPowerTotalBurnTime;
    public static int rocketFuelPowerPerCycleRF;
    public static int rocketFuelPowerTotalBurnTime;
    public static int fireWaterPowerPerCycleRF;
    public static int fireWaterPowerTotalBurnTime;
    public static long nutrientFoodBoostDelay;
    public static boolean rocketFuelIsExplosive;
    public static double xpVacuumRange;
    public static NNList<ResourceLocation> soulVesselBlackList;
    public static NNList<ResourceLocation> soulVesselUnspawnableList;
    public static boolean soulVesselCapturesBosses;
    public static int soulBinderBrokenSpawnerRF;
    public static int soulBinderBrokenSpawnerLevels;
    public static int soulBinderReanimationRF;
    public static int soulBinderReanimationLevels;
    public static int soulBinderEnderCystalRF;
    public static int soulBinderEnderCystalLevels;
    public static int soulBinderPrecientCystalRF;
    public static int soulBinderPrecientCystalLevels;
    public static int soulBinderAttractorCystalRF;
    public static int soulBinderAttractorCystalLevels;
    public static int soulBinderTunedPressurePlateLevels;
    public static int soulBinderTunedPressurePlateRF;
    public static int soulBinderVibrantCystalRF;
    public static int soulBinderVibrantCystalLevels;
    public static float slicenspliceToolDamageChance;
    public static int xpObeliskMaxXpLevel;
    public static boolean clearGlassConnectToFusedQuartz;
    public static boolean glassConnectToTheirVariants;
    public static boolean glassConnectToTheirColorVariants;
    public static boolean rodOfReturnCanTargetAnywhere;
    public static int rodOfReturnTicksToActivate;
    public static int rodOfReturnPowerStorage;
    public static int rodOfReturnMinTicksToRecharge;
    public static int rodOfReturnRfPerTick;
    public static int rodOfReturnFluidUsePerTeleport;
    public static int rodOfReturnFluidStorage;
    public static String rodOfReturnFluidType;
    public static int staffOfLevityFluidUsePerTeleport;
    public static int staffOfLevityFluidStorage;
    public static int staffOfLevityTicksBetweenActivation;
    public static String staffOfLevityFluidType;
    public static boolean paintedGlowstoneRequireSilkTouch;
    public static int maxMobsAttracted;
    public static final Things TRAVEL_BLACKLIST;

    @Nonnull
    public static File getConfigDirectory() {
        return (File)NullHelper.notnull((Object)configDirectory, (String)"trying to access config before preInit");
    }

    public static void init(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Config());
        configDirectory = new File(event.getModConfigurationDirectory(), "enderio");
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        File configFile = new File(configDirectory, "EnderIO.cfg");
        config = new Configuration(configFile);
        Config.syncConfig(false);
    }

    public static void syncConfig(boolean load) {
        try {
            if (load) {
                config.load();
            }
            Config.processConfig(config);
        }
        catch (Exception e) {
            Log.error("EnderIO has a problem loading it's configuration");
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("enderio")) {
            Log.info("Updating config...");
            Config.syncConfig(false);
            Config.init((FMLPostInitializationEvent)null);
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.getModID().equals("enderio")) {
            Log.info("Updating config...");
            Config.syncConfig(true);
            event.setSuccessful();
            Config.init((FMLPostInitializationEvent)null);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketConfigSync(), (EntityPlayerMP)evt.player);
        if ("5.0.37".contains("-") || "5.0.37".contains("@")) {
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "This is an " + TextFormatting.BLACK + "Ender IO " + TextFormatting.DARK_RED + "development build!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "It may trash your world at any time!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Do not use it for anything but testing!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString("You have been warned..."));
        }
    }

    public static void processConfig(Configuration config) {
        conduitPixels = config.get(Config.sectionMisc.name, "conduitPixels", 3, "Valid values are between 2-5, smallest conduits at 2, largest at 5.\nIn SMP, all clients must be using the same value as the server.").getInt(3);
        conduitPixels = MathHelper.func_76125_a((int)conduitPixels, (int)2, (int)5);
        travelAnchorMaximumDistance = config.get(Config.sectionAnchor.name, "travelAnchorMaxDistance", travelAnchorMaximumDistance, "Maximum number of blocks that can be traveled from one travel anchor to another.").getInt(travelAnchorMaximumDistance);
        travelAnchorCooldown = config.get(Config.sectionAnchor.name, "travelAnchorCooldown", travelAnchorCooldown, "Number of ticks in cooldown between activations (1 sec = 20 ticks)").getInt(travelAnchorCooldown);
        travelAnchorSneak = config.get(Config.sectionAnchor.name, "travelAnchorSneak", travelAnchorSneak, "Add sneak as an option to activate travel anchors").getBoolean(travelAnchorSneak);
        travelAnchorSkipWarning = config.get(Config.sectionAnchor.name, "travelAnchorSkipWarning", travelAnchorSkipWarning, "Travel Anchors send a chat warning when skipping inaccessible anchors").getBoolean(travelAnchorSkipWarning);
        travelStaffMaximumDistance = config.get(Config.sectionStaff.name, "travelStaffMaxDistance", travelStaffMaximumDistance, "Maximum number of blocks that can be traveled using the Staff of Traveling.").getInt(travelStaffMaximumDistance);
        travelStaffPowerPerBlockRF = (float)config.get(Config.sectionStaff.name, "travelStaffPowerPerBlockRF", (double)travelStaffPowerPerBlockRF, "Amount of energy required per block traveled using the Staff of Traveling.").getDouble((double)travelStaffPowerPerBlockRF);
        travelStaffMaxBlinkDistance = config.get(Config.sectionStaff.name, "travelStaffMaxBlinkDistance", travelStaffMaxBlinkDistance, "Max number of blocks teleported when shift clicking the staff.").getInt(travelStaffMaxBlinkDistance);
        travelStaffBlinkPauseTicks = config.get(Config.sectionStaff.name, "travelStaffBlinkPauseTicks", travelStaffBlinkPauseTicks, "Minimum number of ticks between 'blinks'. Values of 10 or less allow a limited sort of flight.").getInt(travelStaffBlinkPauseTicks);
        travelStaffBlinkEnabled = config.get(Config.sectionStaff.name, "travelStaffBlinkEnabled", travelStaffBlinkEnabled, "If set to false: the travel staff can not be used to shift-right click teleport, or blink.").getBoolean(travelStaffBlinkEnabled);
        travelStaffBlinkThroughSolidBlocksEnabled = config.get(Config.sectionStaff.name, "travelStaffBlinkThroughSolidBlocksEnabled", travelStaffBlinkThroughSolidBlocksEnabled, "If set to false: the travel staff can be used to blink through any block.").getBoolean(travelStaffBlinkThroughSolidBlocksEnabled);
        travelStaffBlinkThroughClearBlocksEnabled = config.get(Config.sectionItems.name, "travelStaffBlinkThroughClearBlocksEnabled", travelStaffBlinkThroughClearBlocksEnabled, "If travelStaffBlinkThroughSolidBlocksEnabled is set to false and this is true: the travel staff can only be used to blink through transparent or partial blocks (e.g. torches). If both are false: only air blocks may be teleported through.").getBoolean(travelStaffBlinkThroughClearBlocksEnabled);
        travelStaffBlinkThroughUnbreakableBlocksEnabled = config.get(Config.sectionItems.name, "travelStaffBlinkThroughUnbreakableBlocksEnabled", travelStaffBlinkThroughUnbreakableBlocksEnabled, "Allows the travel staff to blink through unbreakable blocks such as warded blocks and bedrock.").getBoolean();
        travelStaffBlinkBlackList = config.getStringList("travelStaffBlinkBlackList", Config.sectionStaff.name, travelStaffBlinkBlackList, "Lists the blocks that cannot be teleported through in the form 'modID:blockName'");
        travelAnchorZoomScale = config.getFloat("travelAnchorZoomScale", Config.sectionStaff.name, travelAnchorZoomScale, 0.0f, 1.0f, "Set the max zoomed size of a travel anchor as an aprox. percentage of screen height");
        travelStaffOffhandBlinkEnabled = config.get(Config.sectionStaff.name, "travelStaffOffhandBlinkEnabled", travelStaffOffhandBlinkEnabled, "If set to false: the travel staff can not be used to shift-right click teleport, or blink, when held in the off-hand.").getBoolean(travelStaffOffhandBlinkEnabled);
        travelStaffOffhandTravelEnabled = config.get(Config.sectionStaff.name, "travelStaffOffhandTravelEnabled", travelStaffOffhandTravelEnabled, "If set to false: the travel staff can not be used to click teleport to Travel Anchors, when held in the off-hand.").getBoolean(travelStaffOffhandTravelEnabled);
        travelStaffOffhandShowsTravelTargets = config.get(Config.sectionStaff.name, "travelStaffOffhandShowsTravelTargets", travelStaffOffhandShowsTravelTargets, "If set to false: Teleportation targets will not be highlighted for travel items held in the off-hand.").getBoolean(travelStaffOffhandShowsTravelTargets);
        rodOfReturnCanTargetAnywhere = config.get(Config.sectionRod.name, "rodOfReturnCanTargetAnywhere", rodOfReturnCanTargetAnywhere, "If set to false the rod of return can only target a telepad.").getBoolean(rodOfReturnCanTargetAnywhere);
        rodOfReturnTicksToActivate = config.get(Config.sectionRod.name, "rodOfReturnTicksToActivate", rodOfReturnTicksToActivate, "Number of ticks the rod must be used before teleporting").getInt(rodOfReturnTicksToActivate);
        rodOfReturnPowerStorage = config.get(Config.sectionRod.name, "rodOfReturnPowerStorage", rodOfReturnPowerStorage, "Internal energy buffer for rod").getInt(rodOfReturnPowerStorage);
        rodOfReturnRfPerTick = config.get(Config.sectionRod.name, "rodOfReturnRfPerTick", rodOfReturnRfPerTick, "energy used per tick").getInt(rodOfReturnRfPerTick);
        rodOfReturnMinTicksToRecharge = config.get(Config.sectionRod.name, "rodOfReturnMinTicksToRecharge", rodOfReturnMinTicksToRecharge, "Min number of ticks required to recharge the internal energy buffer").getInt(rodOfReturnMinTicksToRecharge);
        rodOfReturnFluidStorage = config.get(Config.sectionRod.name, "rodOfReturnFluidStorage", rodOfReturnFluidStorage, "How much fluid the rod can store").getInt(rodOfReturnFluidStorage);
        rodOfReturnFluidUsePerTeleport = config.get(Config.sectionRod.name, "rodOfReturnFluidUsePerTeleport", rodOfReturnFluidUsePerTeleport, "How much fluid is used per teleport").getInt(rodOfReturnFluidUsePerTeleport);
        rodOfReturnFluidType = config.getString("rodOfReturnFluidType", Config.sectionRod.name, rodOfReturnFluidType, "The type of fluid used by the rod.");
        hootchPowerPerCycleRF = config.get(Config.sectionPower.name, "hootchPowerPerCycleRF", hootchPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 30, BC Fuel = 60").getInt(hootchPowerPerCycleRF);
        hootchPowerTotalBurnTime = config.get(Config.sectionPower.name, "hootchPowerTotalBurnTime", hootchPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(hootchPowerTotalBurnTime);
        rocketFuelPowerPerCycleRF = config.get(Config.sectionPower.name, "rocketFuelPowerPerCycleRF", rocketFuelPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 3, BC Fuel = 6").getInt(rocketFuelPowerPerCycleRF);
        rocketFuelPowerTotalBurnTime = config.get(Config.sectionPower.name, "rocketFuelPowerTotalBurnTime", rocketFuelPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(rocketFuelPowerTotalBurnTime);
        fireWaterPowerPerCycleRF = config.get(Config.sectionPower.name, "fireWaterPowerPerCycleRF", fireWaterPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 30, BC Fuel = 60").getInt(fireWaterPowerPerCycleRF);
        fireWaterPowerTotalBurnTime = config.get(Config.sectionPower.name, "fireWaterPowerTotalBurnTime", fireWaterPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(fireWaterPowerTotalBurnTime);
        nutrientFoodBoostDelay = config.get(Config.sectionFluid.name, "nutrientFluidFoodBoostDelay", (double)nutrientFoodBoostDelay, "The delay in ticks between when nutrient distillation boosts your food value.").getInt((int)nutrientFoodBoostDelay);
        rocketFuelIsExplosive = config.get(Config.sectionFluid.name, "rocketFuelIsExplosive", rocketFuelIsExplosive, "If enabled, Rocket Fuel will explode when in contact with fire.").getBoolean();
        xpVacuumRange = config.get(Config.sectionAdvanced.name, "xpVacuumRange", xpVacuumRange, "The distance from which XP will be gathered by the XP vacuum.").getDouble(xpVacuumRange);
        final NNList temp = new NNList();
        soulVesselBlackList.apply((NNList.Callback)new NNList.Callback<ResourceLocation>(){

            public void apply(@Nonnull ResourceLocation rl) {
                temp.add((Object)rl.toString());
            }
        });
        String[] list = config.getStringList("soulVesselBlackList", Config.sectionSoulVial.name, (String[])temp.toArray((Object[])new String[0]), "Entities listed here will can not be captured in a Soul Vial");
        soulVesselBlackList.clear();
        for (String string : list) {
            if (string == null) continue;
            soulVesselBlackList.add((Object)new ResourceLocation(string));
        }
        temp.clear();
        soulVesselUnspawnableList.apply((NNList.Callback)new NNList.Callback<ResourceLocation>(){

            public void apply(@Nonnull ResourceLocation rl) {
                temp.add((Object)rl.toString());
            }
        });
        list = config.getStringList("soulVesselUnspawnableList", Config.sectionSoulVial.name, (String[])temp.toArray((Object[])new String[0]), "Entities listed here cannot be spawned and must be cloned from a captured entity instead (Attention: Possibility of item duping!)");
        soulVesselUnspawnableList.clear();
        for (String string : list) {
            if (string == null) continue;
            soulVesselUnspawnableList.add((Object)new ResourceLocation(string));
        }
        soulVesselCapturesBosses = config.getBoolean("soulVesselCapturesBosses", Config.sectionSoulVial.name, soulVesselCapturesBosses, "When set to false, any mob with a 'boss bar' won't be able to be captured in the Soul Vial. Note: The Ender Dragon can not be captured, even with this enabled. This is a limitation of the dragon, not the Soul Vial.");
        soulBinderBrokenSpawnerRF = config.get(Config.sectionSoulBinder.name, "soulBinderBrokenSpawnerRF", soulBinderBrokenSpawnerRF, "The amount of energy required to change the type of a broken spawner.").getInt(soulBinderBrokenSpawnerRF);
        soulBinderReanimationRF = config.get(Config.sectionSoulBinder.name, "soulBinderReanimationRF", soulBinderReanimationRF, "The amount of energy required to to re-animated a mob head.").getInt(soulBinderReanimationRF);
        soulBinderEnderCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderEnderCystalRF", soulBinderEnderCystalRF, "The amount of energy required to create an ender crystal.").getInt(soulBinderEnderCystalRF);
        soulBinderAttractorCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderAttractorCystalRF", soulBinderAttractorCystalRF, "The amount of energy required to create an attractor crystal.").getInt(soulBinderAttractorCystalRF);
        soulBinderTunedPressurePlateRF = config.get(Config.sectionSoulBinder.name, "soulBinderTunedPressurePlateRF", soulBinderTunedPressurePlateRF, "The amount of energy required to tune a pressure plate.").getInt(soulBinderTunedPressurePlateRF);
        soulBinderPrecientCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderPrecientCystalRF", soulBinderPrecientCystalRF, "The amount of energy required to create a precient crystal.").getInt(soulBinderPrecientCystalRF);
        soulBinderAttractorCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderAttractorCystalLevels", soulBinderAttractorCystalLevels, "The number of levels required to create an attractor crystal.").getInt(soulBinderAttractorCystalLevels);
        soulBinderEnderCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderEnderCystalLevels", soulBinderEnderCystalLevels, "The number of levels required to create an ender crystal.").getInt(soulBinderEnderCystalLevels);
        soulBinderPrecientCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderPrecientCystalLevels", soulBinderPrecientCystalLevels, "The number of levels required to create a precient crystal.").getInt(soulBinderPrecientCystalLevels);
        soulBinderReanimationLevels = config.get(Config.sectionSoulBinder.name, "soulBinderReanimationLevels", soulBinderReanimationLevels, "The number of levels required to re-animate a mob head.").getInt(soulBinderReanimationLevels);
        soulBinderBrokenSpawnerLevels = config.get(Config.sectionSoulBinder.name, "soulBinderBrokenSpawnerLevels", soulBinderBrokenSpawnerLevels, "The number of levels required to change the type of a broken spawner.").getInt(soulBinderBrokenSpawnerLevels);
        soulBinderTunedPressurePlateLevels = config.get(Config.sectionSoulBinder.name, "soulBinderTunedPressurePlateLevels", soulBinderTunedPressurePlateLevels, "The number of levels required to tune a pressure plate.").getInt(soulBinderTunedPressurePlateLevels);
        slicenspliceToolDamageChance = (float)config.get(Config.sectionAdvanced.name, "slicenspliceToolDamageChance", (double)slicenspliceToolDamageChance, "The chance that a tool will take damage each tick while the Slice'n'Splice is running (0 = no chance, 1 = 100% chance). Tools will always take damage when the crafting is finished.").getDouble((double)slicenspliceToolDamageChance);
        xpObeliskMaxXpLevel = config.get(Config.sectionMisc.name, "xpObeliskMaxXpLevel", xpObeliskMaxXpLevel, "Maximum level of XP the xp obelisk can contain.").getInt();
        maxMobsAttracted = config.get(Config.sectionMisc.name, "maxMobsAttracted", maxMobsAttracted, "Maximum number of mobs any Attraction Obelisk can attract at any time.").getInt();
        glassConnectToTheirVariants = config.getBoolean("glassConnectToTheirVariants", Config.sectionMisc.name, glassConnectToTheirVariants, "If true, quite clear glass and fused quartz will connect textures with their respective enlightened and darkened variants.");
        clearGlassConnectToFusedQuartz = config.getBoolean("clearGlassConnectToFusedQuartz", Config.sectionMisc.name, clearGlassConnectToFusedQuartz, "If true, quite clear glass will connect textures with fused quartz.");
        glassConnectToTheirColorVariants = config.getBoolean("glassConnectToTheirColorVariants", Config.sectionMisc.name, glassConnectToTheirColorVariants, "If true, quite clear glass and fused quartz of different colors will connect textures.");
        paintedGlowstoneRequireSilkTouch = config.getBoolean("paintedGlowstoneRequireSilkTouch", Config.sectionMisc.name, paintedGlowstoneRequireSilkTouch, "If true, painted glowstone will drop dust unless broken with silk touch");
        BaseConfig.load();
        BaseConfig.F.setConfig(config);
    }

    public static void init(FMLPostInitializationEvent event) {
    }

    private Config() {
    }

    static {
        sectionPower = new Section("Power Settings", "power");
        sectionItems = new Section("Item Enabling", "item");
        sectionAnchor = new Section("Anchor Settings", "anchor");
        sectionStaff = new Section("Staff Settings", "staff");
        sectionRod = new Section("Rod of Return Settings", "rod");
        sectionAdvanced = new Section("Advanced Settings", "advanced");
        sectionFluid = new Section("Fluid Settings", "fluid");
        sectionSoulBinder = new Section("Soul Binder Settings", "soulBinder");
        sectionSoulVial = new Section("", "soulvial");
        sectionMisc = new Section("Misc", "misc");
        sectionHoes = new Section("Farm Settings.Hoes", "hoes");
        conduitPixels = 3;
        travelAnchorMaximumDistance = 96;
        travelAnchorCooldown = 0;
        travelAnchorSneak = true;
        travelAnchorSkipWarning = true;
        travelStaffMaximumDistance = 256;
        travelStaffPowerPerBlockRF = 250.0f;
        travelStaffMaxBlinkDistance = 16;
        travelStaffBlinkPauseTicks = 10;
        travelStaffBlinkEnabled = true;
        travelStaffBlinkThroughSolidBlocksEnabled = true;
        travelStaffBlinkThroughClearBlocksEnabled = true;
        travelStaffBlinkThroughUnbreakableBlocksEnabled = false;
        travelStaffBlinkBlackList = new String[]{"minecraft:bedrock", "Thaumcraft:blockWarded"};
        travelStaffOffhandBlinkEnabled = true;
        travelStaffOffhandTravelEnabled = true;
        travelStaffOffhandShowsTravelTargets = true;
        travelAnchorZoomScale = 0.2f;
        hootchPowerPerCycleRF = 60;
        hootchPowerTotalBurnTime = 6000;
        rocketFuelPowerPerCycleRF = 160;
        rocketFuelPowerTotalBurnTime = 7000;
        fireWaterPowerPerCycleRF = 80;
        fireWaterPowerTotalBurnTime = 15000;
        nutrientFoodBoostDelay = 400L;
        rocketFuelIsExplosive = true;
        xpVacuumRange = 10.0;
        soulVesselBlackList = new NNList();
        soulVesselUnspawnableList = new NNList();
        soulVesselCapturesBosses = false;
        soulBinderBrokenSpawnerRF = 2500000;
        soulBinderBrokenSpawnerLevels = 8;
        soulBinderReanimationRF = 100000;
        soulBinderReanimationLevels = 4;
        soulBinderEnderCystalRF = 150000;
        soulBinderEnderCystalLevels = 6;
        soulBinderPrecientCystalRF = 200000;
        soulBinderPrecientCystalLevels = 8;
        soulBinderAttractorCystalRF = 100000;
        soulBinderAttractorCystalLevels = 4;
        soulBinderTunedPressurePlateLevels = 2;
        soulBinderTunedPressurePlateRF = 250000;
        soulBinderVibrantCystalRF = 200000;
        soulBinderVibrantCystalLevels = 8;
        slicenspliceToolDamageChance = 0.01f;
        xpObeliskMaxXpLevel = Integer.MAX_VALUE;
        clearGlassConnectToFusedQuartz = false;
        glassConnectToTheirVariants = true;
        glassConnectToTheirColorVariants = true;
        rodOfReturnCanTargetAnywhere = false;
        rodOfReturnTicksToActivate = 50;
        rodOfReturnPowerStorage = 2000000;
        rodOfReturnMinTicksToRecharge = 100;
        rodOfReturnRfPerTick = 35000;
        rodOfReturnFluidUsePerTeleport = 200;
        rodOfReturnFluidStorage = 200;
        rodOfReturnFluidType = "ender_distillation";
        staffOfLevityFluidUsePerTeleport = 100;
        staffOfLevityFluidStorage = 8000;
        staffOfLevityTicksBetweenActivation = 10;
        staffOfLevityFluidType = "vapor_of_levity";
        paintedGlowstoneRequireSilkTouch = false;
        maxMobsAttracted = 20;
        TRAVEL_BLACKLIST = new Things(travelStaffBlinkBlackList);
    }

    public static class Section {
        @Nonnull
        public final String name;

        public Section(String name, @Nonnull String lang) {
            this.name = lang;
        }
    }
}

