/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.geom;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.geom.GeometryKey;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public final class ConduitGeometryUtil {
    @Nonnull
    public static final ConduitGeometryUtil instance = new ConduitGeometryUtil();
    private static float WIDTH;
    private static float HEIGHT;
    private static float HWIDTH;
    private static float HHEIGHT;
    private static BoundingBox CORE_BOUNDS;
    public static final float CONNECTOR_DEPTH = 0.05f;
    @Nonnull
    private static final Map<EnumFacing, BoundingBox[]> EXTERNAL_CONNECTOR_BOUNDS;
    @Nonnull
    private final Map<GeometryKey, BoundingBox> boundsCache = new HashMap<GeometryKey, BoundingBox>();

    @SubscribeEvent
    public static void preInit(EnderIOLifecycleEvent.Config.Post event) {
        float size;
        WIDTH = size = 0.0625f * (float)Config.conduitPixels;
        HEIGHT = size;
        HWIDTH = WIDTH / 2.0f;
        HHEIGHT = HEIGHT / 2.0f;
        Vector3d core_min = new Vector3d((double)(0.5f - HWIDTH), 0.5 - (double)HHEIGHT, 0.5 - (double)HWIDTH);
        Vector3d core_max = new Vector3d(core_min.x + (double)WIDTH, core_min.y + (double)HEIGHT, core_min.z + (double)WIDTH);
        CORE_BOUNDS = new BoundingBox(core_min, core_max);
        float connectorWidth = Math.min(0.125f + size * 3.0f, 1.0f);
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            EXTERNAL_CONNECTOR_BOUNDS.put(dir, ConduitGeometryUtil.createExternalConnector(dir, 0.05f, connectorWidth));
        }
    }

    @Nonnull
    private static BoundingBox[] createExternalConnector(@Nonnull EnumFacing dir, float connectorDepth, float connectorWidth) {
        BoundingBox[] res = new BoundingBox[2];
        float cMin = 0.5f - connectorWidth / 2.0f;
        float cMax = 0.5f + connectorWidth / 2.0f;
        float dMin = 1.0f - connectorDepth / 2.0f;
        float dMax = 1.0f;
        res[0] = ConduitGeometryUtil.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        cMin = 0.5f - connectorWidth / 3.0f;
        cMax = 0.5f + connectorWidth / 3.0f;
        dMin = 1.0f - connectorDepth;
        dMax = 1.0f - connectorDepth / 2.0f;
        res[1] = ConduitGeometryUtil.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        return res;
    }

    @Nonnull
    private static BoundingBox createConnectorComponent(@Nonnull EnumFacing dir, float cornerMin, float cornerMax, float depthMin, float depthMax) {
        float minX = (float)(1 - Math.abs(dir.func_82601_c())) * cornerMin + (float)dir.func_82601_c() * depthMin;
        float minY = (float)(1 - Math.abs(dir.func_96559_d())) * cornerMin + (float)dir.func_96559_d() * depthMin;
        float minZ = (float)(1 - Math.abs(dir.func_82599_e())) * cornerMin + (float)dir.func_82599_e() * depthMin;
        float maxX = (float)(1 - Math.abs(dir.func_82601_c())) * cornerMax + (float)dir.func_82601_c() * depthMax;
        float maxY = (float)(1 - Math.abs(dir.func_96559_d())) * cornerMax + (float)dir.func_96559_d() * depthMax;
        float maxZ = (float)(1 - Math.abs(dir.func_82599_e())) * cornerMax + (float)dir.func_82599_e() * depthMax;
        minX = ConduitGeometryUtil.fix(minX);
        minY = ConduitGeometryUtil.fix(minY);
        minZ = ConduitGeometryUtil.fix(minZ);
        maxX = ConduitGeometryUtil.fix(maxX);
        maxY = ConduitGeometryUtil.fix(maxY);
        maxZ = ConduitGeometryUtil.fix(maxZ);
        BoundingBox bb = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        bb = bb.fixMinMax();
        return bb;
    }

    private static float fix(float val) {
        return val < 0.0f ? 1.0f + val : val;
    }

    private ConduitGeometryUtil() {
    }

    @Nonnull
    public BoundingBox getExternalConnectorBoundingBox(@Nonnull EnumFacing dir) {
        return this.getExternalConnectorBoundingBoxes(dir)[0];
    }

    @Nonnull
    public BoundingBox[] getExternalConnectorBoundingBoxes(@Nonnull EnumFacing dir) {
        return EXTERNAL_CONNECTOR_BOUNDS.get(dir);
    }

    @Nonnull
    public BoundingBox getBoundingBox(@Nonnull Class<? extends IConduit> type, EnumFacing dir, @Nonnull Offset offset) {
        GeometryKey key = new GeometryKey(dir, offset, type);
        BoundingBox result = this.boundsCache.get(key);
        if (result == null) {
            result = this.createConduitBounds(type, key);
            this.boundsCache.put(key, result);
        }
        return result;
    }

    @Nonnull
    public Vector3d getTranslation(EnumFacing dir, @Nonnull Offset offset) {
        Vector3d result = new Vector3d((double)offset.xOffset, (double)offset.yOffset, (double)offset.zOffset);
        result.scale((double)WIDTH);
        return result;
    }

    @Nonnull
    public BoundingBox createBoundsForConnectionController(@Nonnull EnumFacing dir, @Nonnull Offset offset) {
        Vector3d nonUniformScale = ForgeDirectionOffsets.forDirCopy((EnumFacing)dir);
        nonUniformScale.scale(0.5);
        nonUniformScale.x = 0.8 * (1.0 - Math.abs(nonUniformScale.x));
        nonUniformScale.y = 0.8 * (1.0 - Math.abs(nonUniformScale.y));
        nonUniformScale.z = 0.8 * (1.0 - Math.abs(nonUniformScale.z));
        BoundingBox bb = CORE_BOUNDS;
        bb = bb.scale(nonUniformScale.x, nonUniformScale.y, nonUniformScale.z);
        double offsetFromEnd = Math.min(bb.sizeX(), bb.sizeY());
        offsetFromEnd = Math.min(offsetFromEnd, bb.sizeZ());
        offsetFromEnd = Math.max(offsetFromEnd, 0.075);
        double transMag = 0.5 - offsetFromEnd * 1.2;
        Vector3d trans = ForgeDirectionOffsets.forDirCopy((EnumFacing)dir);
        trans.scale(transMag);
        bb = bb.translate(trans);
        bb = bb.translate(this.getTranslation(dir, offset));
        return bb;
    }

    @Nonnull
    private BoundingBox createConduitBounds(@Nonnull Class<? extends IConduit> type, @Nonnull GeometryKey key) {
        return this.createConduitBounds(type, key.dir, key.offset);
    }

    @Nonnull
    private BoundingBox createConduitBounds(Class<? extends IConduit> type, EnumFacing dir, @Nonnull Offset offset) {
        BoundingBox bb = CORE_BOUNDS;
        Vector3d min = bb.getMin();
        Vector3d max = bb.getMax();
        if (dir != null) {
            switch (dir) {
                case WEST: {
                    min.x = 0.0;
                    max.x = bb.field_72340_a;
                    break;
                }
                case EAST: {
                    min.x = bb.field_72336_d;
                    max.x = 1.0;
                    break;
                }
                case DOWN: {
                    min.y = 0.0;
                    max.y = bb.field_72338_b;
                    break;
                }
                case UP: {
                    min.y = bb.field_72337_e;
                    max.y = 1.0;
                    break;
                }
                case NORTH: {
                    min.z = 0.0;
                    max.z = bb.field_72339_c;
                    break;
                }
                case SOUTH: {
                    min.z = bb.field_72334_f;
                    max.z = 1.0;
                    break;
                }
            }
        }
        Vector3d trans = this.getTranslation(dir, offset);
        min.add(trans);
        max.add(trans);
        bb = new BoundingBox(VecmathUtil.clamp((Vector3d)min, (double)0.0, (double)1.0), VecmathUtil.clamp((Vector3d)max, (double)0.0, (double)1.0));
        return bb;
    }

    public static BoundingBox getCoreBounds() {
        return CORE_BOUNDS;
    }

    public static float getHeight() {
        return HEIGHT;
    }

    public static float getHalfWidth() {
        return HWIDTH;
    }

    static {
        EXTERNAL_CONNECTOR_BOUNDS = new EnumMap<EnumFacing, BoundingBox[]>(EnumFacing.class);
    }
}

