/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.gui;

import amerifrance.guideapi.GuideMod;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.button.ButtonBack;
import amerifrance.guideapi.button.ButtonNext;
import amerifrance.guideapi.button.ButtonPrev;
import amerifrance.guideapi.gui.GuiBase;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiSearch
extends GuiBase {
    private Book book;
    private ResourceLocation outlineTexture;
    private ResourceLocation pageTexture;
    private ButtonNext buttonNext;
    private ButtonPrev buttonPrev;
    private GuiTextField searchField;
    private GuiScreen parent;
    private List<List<Pair<EntryAbstract, CategoryAbstract>>> searchResults;
    private int currentPage = 0;
    private String lastQuery = "";

    public GuiSearch(Book book, EntityPlayer player, ItemStack bookStack, GuiScreen parent) {
        super(player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.parent = parent;
        this.searchResults = GuiSearch.getMatches(book, null, player, bookStack);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.func_189646_b(new ButtonBack(0, this.guiLeft + this.xSize / 6, this.guiTop, this));
        this.buttonNext = new ButtonNext(1, this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, this);
        this.func_189646_b(this.buttonNext);
        this.buttonPrev = new ButtonPrev(2, this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, this);
        this.func_189646_b(this.buttonPrev);
        this.searchField = new GuiTextField(3, this.field_146289_q, this.guiLeft + 43, this.guiTop + 12, 100, 10);
        this.searchField.func_146185_a(false);
        this.searchResults = GuiSearch.getMatches(this.book, null, this.player, this.bookStack);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(this.pageTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.field_146297_k.func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.getColor());
        GuiSearch.func_73734_a((int)(this.searchField.field_146209_f - 1), (int)(this.searchField.field_146210_g - 1), (int)(this.searchField.field_146209_f + this.searchField.field_146218_h + 1), (int)(this.searchField.field_146210_g + this.searchField.field_146219_i + 1), (int)new Color(166, 166, 166, 128).getRGB());
        GuiSearch.func_73734_a((int)this.searchField.field_146209_f, (int)this.searchField.field_146210_g, (int)(this.searchField.field_146209_f + this.searchField.field_146218_h), (int)(this.searchField.field_146210_g + this.searchField.field_146219_i), (int)new Color(58, 58, 58, 128).getRGB());
        this.searchField.func_146194_f();
        int entryX = this.guiLeft + 37;
        int entryY = this.guiTop + 30;
        if (this.searchResults.size() != 0 && this.currentPage >= 0 && this.currentPage < this.searchResults.size()) {
            List<Pair<EntryAbstract, CategoryAbstract>> pageResults = this.searchResults.get(this.currentPage);
            for (Pair<EntryAbstract, CategoryAbstract> entry : pageResults) {
                ((EntryAbstract)entry.getLeft()).draw(this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.field_146289_q);
                ((EntryAbstract)entry.getLeft()).drawExtras(this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.field_146289_q);
                if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, 4 * this.xSize / 6, 10)) {
                    if (Keyboard.isKeyDown((int)42)) {
                        GuiUtils.drawHoveringText((List)Lists.newArrayList((Object[])new String[]{((CategoryAbstract)entry.getRight()).getLocalizedName()}), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)300, (FontRenderer)this.field_146289_q);
                    }
                    if (Mouse.isButtonDown((int)0)) {
                        GuideMod.PROXY.openEntry(this.book, (CategoryAbstract)entry.getRight(), (EntryAbstract)entry.getLeft(), this.player, this.bookStack);
                        return;
                    }
                }
                entryY += 13;
            }
        }
        this.buttonPrev.field_146125_m = this.currentPage != 0;
        this.buttonNext.field_146125_m = this.currentPage != this.searchResults.size() - 1 && !this.searchResults.isEmpty();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            if (GuiHelper.isMouseBetween(mouseX, mouseY, this.searchField.field_146209_f, this.searchField.field_146210_g, this.searchField.field_146218_h, this.searchField.field_146219_i)) {
                this.searchField.func_146180_a("");
                this.lastQuery = "";
                this.searchResults = GuiSearch.getMatches(this.book, "", this.player, this.bookStack);
                return;
            }
            this.field_146297_k.func_147108_a(this.parent);
        }
        this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int movement = Mouse.getEventDWheel();
        if (movement < 0 && this.buttonNext.field_146125_m && this.currentPage <= this.searchResults.size()) {
            ++this.currentPage;
        } else if (movement > 0 && this.buttonPrev.field_146125_m && this.currentPage > 0) {
            --this.currentPage;
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        if (!this.searchField.func_146206_l()) {
            super.func_73869_a(typedChar, keyCode);
        }
        if (keyCode == 1) {
            this.searchField.func_146195_b(false);
        }
        this.searchField.func_146201_a(typedChar, keyCode);
        if (!this.searchField.func_146179_b().equalsIgnoreCase(this.lastQuery)) {
            this.lastQuery = this.searchField.func_146179_b();
            this.searchResults = GuiSearch.getMatches(this.book, this.searchField.func_146179_b(), this.player, this.bookStack);
            if (this.currentPage > this.searchResults.size()) {
                this.currentPage = this.searchResults.size() - 1;
            }
        }
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.field_146297_k.func_147108_a(this.parent);
                break;
            }
            case 1: {
                if (this.currentPage > this.searchResults.size() - 1) break;
                ++this.currentPage;
                break;
            }
            case 2: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
            }
        }
    }

    @Nonnull
    static List<List<Pair<EntryAbstract, CategoryAbstract>>> getMatches(Book book, @Nullable String query, EntityPlayer player, ItemStack bookStack) {
        ArrayList discovered = Lists.newArrayList();
        for (CategoryAbstract category : book.getCategoryList()) {
            if (!category.canSee(player, bookStack)) continue;
            for (EntryAbstract entry : category.entries.values()) {
                if (!entry.canSee(player, bookStack) || !Strings.isNullOrEmpty((String)query) && !entry.getLocalizedName().toLowerCase(Locale.ENGLISH).contains(query.toLowerCase(Locale.ENGLISH))) continue;
                discovered.add(Pair.of((Object)entry, (Object)category));
            }
        }
        return Lists.partition((List)discovered, (int)10);
    }
}

