/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.gui.RedstoneModeButton;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.gui.BaseSettingsPanel;
import crazypants.enderio.conduits.gui.ConduitRedstoneModeControlable;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.network.PacketExtractMode;
import crazypants.enderio.conduits.network.PacketItemConduitFilter;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemSettings
extends BaseSettingsPanel {
    private static final int ID_REDSTONE_BUTTON = 12614;
    private static final int ID_COLOR_BUTTON = 179816;
    private static final int ID_LOOP = 22;
    private static final int ID_ROUND_ROBIN = 24;
    private static final int ID_PRIORITY_UP = 25;
    private static final int ID_PRIORITY_DOWN = 26;
    private static final int ID_INSERT_CHANNEL = 23;
    private static final int ID_EXTRACT_CHANNEL = 27;
    @Nonnull
    private IItemConduit itemConduit;
    private final ToggleButton loopB;
    private final ToggleButton roundRobinB;
    private final MultiIconButton priUpB;
    private final MultiIconButton priDownB;
    private final RedstoneModeButton<?> rsB;
    @Nonnull
    private final ColorButton colorB;
    private ColorButton insertChannelB;
    private ColorButton extractChannelB;
    private int priLeft = 46;
    private int priWidth = 32;

    public ItemSettings(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        super((IWidgetIcon)IconEIO.WRENCH_OVERLAY_ITEM, ConduitObject.item_item_conduit.getUnlocalisedName(), gui, con, "filter_upgrade_settings");
        this.itemConduit = (IItemConduit)con;
        int x = this.leftColumn;
        int y = this.customTop;
        this.insertChannelB = new ColorButton((IGuiScreen)gui, 23, x, y);
        this.insertChannelB.setColorIndex(0);
        this.insertChannelB.setToolTipHeading(Lang.GUI_CONDUIT_CHANNEL.get());
        x = this.rightColumn;
        this.extractChannelB = new ColorButton((IGuiScreen)gui, 27, x, y);
        this.extractChannelB.setColorIndex(0);
        this.extractChannelB.setToolTipHeading(Lang.GUI_CONDUIT_CHANNEL.get());
        this.roundRobinB = new ToggleButton((IGuiScreen)gui, 24, x += 4 + this.extractChannelB.getWidth(), y, (IWidgetIcon)IconEIO.ROUND_ROBIN_OFF, (IWidgetIcon)IconEIO.ROUND_ROBIN);
        this.roundRobinB.setSelectedToolTip(new String[]{Lang.GUI_ROUND_ROBIN_ENABLED.get()});
        this.roundRobinB.setUnselectedToolTip(new String[]{Lang.GUI_ROUND_ROBIN_DISABLED.get()});
        this.roundRobinB.setPaintSelectedBorder(false);
        this.loopB = new ToggleButton((IGuiScreen)gui, 22, x += 4 + this.roundRobinB.getWidth(), y, (IWidgetIcon)IconEIO.LOOP_OFF, (IWidgetIcon)IconEIO.LOOP);
        this.loopB.setSelectedToolTip(new String[]{Lang.GUI_SELF_FEED_ENABLED.get()});
        this.loopB.setUnselectedToolTip(new String[]{Lang.GUI_SELF_FEED_DISABLED.get()});
        this.loopB.setPaintSelectedBorder(false);
        x = this.rightColumn;
        int x0 = x + 20;
        this.colorB = new ColorButton((IGuiScreen)gui, 179816, x0, y += this.insertChannelB.getHeight() + 6);
        this.colorB.setColorIndex(this.itemConduit.getExtractionSignalColor(gui.getDir()).ordinal());
        this.colorB.setToolTipHeading(Lang.GUI_SIGNAL_COLOR.get());
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, 12614, x, y, (IRedstoneModeControlable)new ConduitRedstoneModeControlable(this.itemConduit, gui, this.colorB));
        x = this.priLeft + this.priWidth + 9;
        this.priUpB = MultiIconButton.createAddButton((IGuiScreen)gui, (int)25, (int)x, (int)y);
        this.priDownB = MultiIconButton.createMinusButton((IGuiScreen)gui, (int)26, (int)x, (int)(y + 8));
    }

    @Override
    protected void initCustomOptions() {
        this.gui.getContainer().setInOutSlotsVisible(true, true, (IConduit)this.itemConduit);
        this.gui.getContainer().createGhostSlots(this.gui.getGhostSlotHandler().getGhostSlots());
        this.updateGuiVisibility();
    }

    private void updateGuiVisibility() {
        this.updateButtons();
    }

    private void updateButtons() {
        this.rsB.onGuiInit();
        this.rsB.setMode(RedstoneControlMode.IconHolder.getFromMode((RedstoneControlMode)this.itemConduit.getExtractionRedstoneMode(this.gui.getDir())));
        this.loopB.onGuiInit();
        this.loopB.setSelected(this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
        this.roundRobinB.onGuiInit();
        this.roundRobinB.setSelected(this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
        this.priUpB.onGuiInit();
        this.priDownB.onGuiInit();
        this.insertChannelB.onGuiInit();
        this.insertChannelB.setColorIndex(this.itemConduit.getOutputColor(this.gui.getDir()).ordinal());
        this.extractChannelB.onGuiInit();
        this.extractChannelB.setColorIndex(this.itemConduit.getInputColor(this.gui.getDir()).ordinal());
    }

    @Override
    public void actionPerformed(@Nonnull GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == 179816) {
            this.itemConduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.fromIndex((int)this.colorB.getColorIndex()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.itemConduit, this.gui.getDir()));
            return;
        }
        if (guiButton.field_146127_k == 22) {
            this.itemConduit.setSelfFeedEnabled(this.gui.getDir(), !this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
        } else if (guiButton.field_146127_k == 24) {
            this.itemConduit.setRoundRobinEnabled(this.gui.getDir(), !this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
        } else if (guiButton.field_146127_k == 25) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) + 1);
        } else if (guiButton.field_146127_k == 26) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) - 1);
        } else if (guiButton.field_146127_k == 23) {
            DyeColor col = DyeColor.fromIndex((int)this.insertChannelB.getColorIndex());
            this.itemConduit.setOutputColor(this.gui.getDir(), col);
        } else if (guiButton.field_146127_k == 27) {
            DyeColor col = DyeColor.fromIndex((int)this.extractChannelB.getColorIndex());
            this.itemConduit.setInputColor(this.gui.getDir(), col);
        } else {
            if (guiButton.field_146127_k == 329) {
                this.doOpenFilterGui(2);
                return;
            }
            if (guiButton.field_146127_k == 330) {
                this.doOpenFilterGui(1);
                return;
            }
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
    }

    @Override
    protected void connectionModeChanged(@Nonnull ConnectionMode mode) {
        super.connectionModeChanged(mode);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.itemConduit, this.gui.getDir()));
        this.updateGuiVisibility();
    }

    @Override
    protected void renderCustomOptions(int top1, float par1, int par2, int par3) {
        FontRenderer fr = this.gui.getFontRenderer();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        IconEIO.map.render((IWidgetIcon)EnderWidget.BUTTON_DOWN, (double)(this.left + this.priLeft), (double)(top1 - 5), (double)this.priWidth, 16.0, 0.0, true);
        String str = this.itemConduit.getOutputPriority(this.gui.getDir()) + "";
        int sw = fr.func_78256_a(str);
        String priority = Lang.GUI_PRIORITY.get();
        fr.func_78276_b(priority, this.left + 12, top1 + 25, ColorUtil.getRGB((Color)Color.black));
        fr.func_78276_b(str, this.left + this.priLeft + this.priWidth - sw - this.gap, top1 + 25, ColorUtil.getRGB((Color)Color.black));
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.gui.getContainer().setInOutSlotsVisible(false, false, (IConduit)this.itemConduit);
        this.rsB.detach();
        this.colorB.detach();
        this.roundRobinB.detach();
        this.loopB.detach();
        this.priUpB.detach();
        this.priDownB.detach();
        this.insertChannelB.detach();
        this.extractChannelB.detach();
    }

    @Override
    protected boolean hasFilters() {
        return true;
    }

    @Override
    protected boolean hasUpgrades() {
        return true;
    }
}

