/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.tinkeredhegemony;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.tinkeredhegemony.TinkerReflectionWrapper;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class IngredientTinkerTool
extends Ingredient {
    private final Class<?> itemClass;
    private final Collection<Pair<Material, IToolPart>> requiredParts;

    protected IngredientTinkerTool(Item tconItem, Class itemClass, Collection<Pair<Material, IToolPart>> requiredParts) {
        super(IngredientTinkerTool.getExampleStacks(tconItem, itemClass, requiredParts));
        this.itemClass = itemClass;
        this.requiredParts = requiredParts;
    }

    private static ItemStack[] getExampleStacks(Item i, Class itemClass, Collection<Pair<Material, IToolPart>> requiredParts) {
        NonNullList stacks = NonNullList.func_191196_a();
        i.func_150895_a(CreativeTabs.field_78027_g, stacks);
        return (ItemStack[])stacks.stream().filter(a -> IngredientTinkerTool.apply(a, itemClass, requiredParts)).toArray(ItemStack[]::new);
    }

    private static boolean apply(@Nullable ItemStack stack, Class<?> itemClass, Collection<Pair<Material, IToolPart>> requiredParts) {
        if (stack == null || stack.func_190926_b() || stack.func_77952_i() != 0) {
            return false;
        }
        if (itemClass.isAssignableFrom(stack.func_77973_b().getClass()) && stack.func_77942_o()) {
            List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)stack));
            List<PartMaterialType> components = TinkerReflectionWrapper.getRequiredComponents(stack.func_77973_b());
            if (components.isEmpty()) {
                return false;
            }
            HashSet<IToolPart> partsSeen = new HashSet<IToolPart>();
            HashSet<IToolPart> partsFound = new HashSet<IToolPart>();
            if (components.size() <= materials.size()) {
                HashSet rp = Sets.newHashSet(requiredParts);
                for (int i = 0; i < components.size(); ++i) {
                    Material m = (Material)materials.get(i);
                    PartMaterialType c = components.get(i);
                    for (IToolPart part : c.getPossibleParts()) {
                        if (rp.remove(Pair.of((Object)m, (Object)part))) {
                            partsFound.add(part);
                            continue;
                        }
                        partsSeen.add(part);
                    }
                }
                rp.removeIf(p -> !partsSeen.contains(p.getRight()) || partsFound.contains(p.getRight()));
                if (rp.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean apply(@Nullable ItemStack stack) {
        return IngredientTinkerTool.apply(stack, this.itemClass, this.requiredParts);
    }
}

