/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.tinkeredhegemony;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.tinkeredhegemony.IngredientTinkerTool;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;

public class DisabledItemClass {
    private final String name;
    private final Predicate<Item> itemPredicate;
    private final Item tconItem;
    private final Class<? extends Item> tconItemClass;
    private final Collection<IToolPart> partsMaterialMatch;
    private final Set<Item> itemSet;

    public DisabledItemClass(String name, Predicate<Item> itemPredicate, Item tconItem, Class<? extends Item> tconItemClass, IToolPart ... partsMaterialMatch) {
        this.name = name;
        this.itemPredicate = itemPredicate;
        this.tconItem = tconItem;
        this.tconItemClass = tconItemClass;
        this.partsMaterialMatch = ImmutableSet.copyOf((Object[])partsMaterialMatch);
        this.itemSet = new HashSet<Item>();
    }

    public Set<Item> getItemSet() {
        return this.itemSet;
    }

    protected void updateItemSet(Set<Item> set) {
        this.itemSet.clear();
        for (Item i : set) {
            if (!this.getItemPredicate().test(i)) continue;
            this.itemSet.add(i);
        }
    }

    public Collection<IToolPart> getPartsMaterialMatch() {
        return this.partsMaterialMatch;
    }

    public boolean tconItemMatches(Item i) {
        return this.tconItemClass.isAssignableFrom(i.getClass());
    }

    public Predicate<Item> getItemPredicate() {
        return this.itemPredicate;
    }

    public String getName() {
        return this.name;
    }

    public IngredientTinkerTool createIngredient(Material ... materials) {
        return this.createIngredient(Arrays.asList(materials));
    }

    public IngredientTinkerTool createIngredient(Collection<Material> materials) {
        ImmutableSet.Builder data = new ImmutableSet.Builder();
        for (IToolPart p : this.partsMaterialMatch) {
            for (Material m : materials) {
                data.add((Object)Pair.of((Object)m, (Object)p));
            }
        }
        return new IngredientTinkerTool(this.tconItem, this.tconItemClass, (Collection<Pair<Material, IToolPart>>)data.build());
    }
}

