/*
 * Decompiled with CFR 0.152.
 */
package betterwithengineering.base;

import betterwithengineering.BWE;
import betterwithengineering.enc.ExNihilo;
import betterwithengineering.ie.HempFix;
import betterwithengineering.ie.MechPower;
import betterwithengineering.ie.SteelRebalance;
import betterwithengineering.ie.TreatedWood;
import betterwithmods.module.Feature;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CompatLoader {
    public static HashMultimap<String, Class<? extends Feature>> COMPAT_CLASS = HashMultimap.create();
    public static List<Feature> features = Lists.newArrayList();

    public static void construct() {
        if (BWE.ConfigManager.immersiveEngineering.mechPower.enabled) {
            COMPAT_CLASS.put((Object)"immersiveengineering", MechPower.class);
        }
        if (BWE.ConfigManager.immersiveEngineering.overrideIndustrialHempDrops) {
            COMPAT_CLASS.put((Object)"immersiveengineering", HempFix.class);
        }
        if (BWE.ConfigManager.ImmersiveEngineering.addTreatedWood) {
            COMPAT_CLASS.put((Object)"immersiveengineering", TreatedWood.class);
        }
        if (BWE.ConfigManager.immersiveEngineering.steel.enabled) {
            COMPAT_CLASS.put((Object)"immersiveengineering", SteelRebalance.class);
        }
        if (BWE.ConfigManager.thermalExpansion.hardcoreInductionSmelter) {
            try {
                Class<?> clazz = Class.forName("betterwithengineering.te.ThermalExpansion");
                if (clazz != null) {
                    COMPAT_CLASS.put((Object)"thermalexpansion", clazz);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (BWE.ConfigManager.exNihilo.supportMechPower) {
            COMPAT_CLASS.put((Object)"exnihilocreatio", ExNihilo.MechPower.class);
        }
        for (String key : COMPAT_CLASS.keySet()) {
            if (!Loader.isModLoaded((String)key)) continue;
            for (Class c : COMPAT_CLASS.get((Object)key)) {
                try {
                    Feature f = (Feature)c.newInstance();
                    if (f.hasSubscriptions()) {
                        MinecraftForge.EVENT_BUS.register((Object)f);
                    }
                    if (f.configName == null) {
                        f.configName = f.getClass().getSimpleName();
                    }
                    features.add(f);
                    BWE.logger.info("Loading BWE Compat: {}", (Object)f.configName);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void preInit(FMLPreInitializationEvent event) {
        features.forEach(c -> c.preInit(event));
    }

    public static void init(FMLInitializationEvent event) {
        features.forEach(c -> c.init(event));
    }

    public static void postInit(FMLPostInitializationEvent event) {
        features.forEach(c -> c.postInit(event));
    }

    private static boolean isLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }
}

