/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.forestry;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.fluids.Fluids;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.compat.ICompatModule;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemCells;
import techreborn.items.ItemDynamicCell;

@RebornRegistry(modOnly="forestry", modID="techreborn")
public class ForestryCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="forestry", key="EnableDistillationTowerForestryRecipes", comment="Enable distillation tower recipes envolving Forestry fuels")
    public static boolean enableDistillationTowerForestryRecipes = true;
    @ConfigRegistry(config="compat", category="forestry", key="EnableForestryFuels", comment="Allow Forestry fuels to be used in the fuel generators")
    public static boolean allowForestryFuels = true;

    public void init(FMLInitializationEvent event) {
        if (enableDistillationTowerForestryRecipes) {
            RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe((Object)ItemCells.getCellByName((String)Fluids.BIOMASS.getTag(), (int)16), null, RecipeMethods.getMaterial((String)Fluids.BIO_ETHANOL.getTag(), (int)8, (RecipeMethods.Type)RecipeMethods.Type.CELL), ItemDynamicCell.getEmptyCell((int)8), null, null, 400, 16));
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (allowForestryFuels) {
            GeneratorFuel biomass = (GeneratorFuel)FuelManager.generatorFuel.get(Fluids.BIOMASS.getFluid());
            GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.SEMIFLUID, (Fluid)Fluids.BIOMASS.getFluid(), (int)(biomass.getEu() * biomass.getRate()));
            GeneratorFuel ethanol = (GeneratorFuel)FuelManager.generatorFuel.get(Fluids.BIO_ETHANOL.getFluid());
            GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.DIESEL, (Fluid)Fluids.BIO_ETHANOL.getFluid(), (int)(ethanol.getEu() * ethanol.getRate()));
        }
    }
}

