/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import com.google.common.collect.Maps;
import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.util.EntityUtils;
import fi.dy.masa.worldprimer.util.PositionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Schematic {
    public static ChiselsAndBitsHandler chiselsAndBitsHandler = new ChiselsAndBitsHandler();
    private BlockPos size = BlockPos.field_177992_a;
    private IBlockState[] blocks;
    private Block[] palette;
    private Map<BlockPos, NBTTagCompound> tiles = new HashMap<BlockPos, NBTTagCompound>();
    private List<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();
    private String fileName;

    private Schematic() {
    }

    public BlockPos getSize() {
        return this.size;
    }

    public void placeSchematicToWorld(World world, BlockPos posStart, PlacementSettings placement, int setBlockStateFlags) {
        int width = this.size.func_177958_n();
        int height = this.size.func_177956_o();
        int length = this.size.func_177952_p();
        int numBlocks = width * height * length;
        if (this.blocks != null && this.blocks.length == numBlocks && numBlocks > 0) {
            int x;
            int z;
            int y;
            Block ignoredBlock = placement.func_186219_f();
            int index = 0;
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    x = 0;
                    while (x < width) {
                        IBlockState state = this.blocks[index];
                        if (ignoredBlock == null || state.func_177230_c() != ignoredBlock) {
                            TileEntity te;
                            BlockPos pos = new BlockPos(x, y, z);
                            NBTTagCompound teNBT = this.tiles.get(pos);
                            pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vec3i)posStart);
                            state = state.func_185902_a(placement.func_186212_b());
                            state = state.func_185907_a(placement.func_186215_c());
                            if (teNBT != null && (te = world.func_175625_s(pos)) != null) {
                                if (te instanceof IInventory) {
                                    ((IInventory)te).func_174888_l();
                                }
                                world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 4);
                            }
                            if (world.func_180501_a(pos, state, setBlockStateFlags) && teNBT != null && (te = world.func_175625_s(pos)) != null) {
                                teNBT.func_74768_a("x", pos.func_177958_n());
                                teNBT.func_74768_a("y", pos.func_177956_o());
                                teNBT.func_74768_a("z", pos.func_177952_p());
                                te.func_145839_a(teNBT);
                                te.func_189668_a(placement.func_186212_b());
                                te.func_189667_a(placement.func_186215_c());
                            }
                        }
                        ++x;
                        ++index;
                    }
                }
            }
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    for (x = 0; x < width; ++x) {
                        TileEntity te;
                        BlockPos pos = new BlockPos(x, y, z);
                        NBTTagCompound teNBT = this.tiles.get(pos);
                        pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vec3i)posStart);
                        world.func_175722_b(pos, world.func_180495_p(pos).func_177230_c(), false);
                        if (teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                        te.func_70296_d();
                    }
                }
            }
            if (!placement.func_186221_e()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    private void addEntitiesToWorld(World world, BlockPos posStart, PlacementSettings placement) {
        Mirror mirror = placement.func_186212_b();
        Rotation rotation = placement.func_186215_c();
        BlockPos posEnd = posStart.func_177971_a((Vec3i)PositionUtils.getRelativeEndPositionFromAreaSize(this.size));
        BlockPos pos1 = PositionUtils.getMinCorner(posStart, posEnd);
        BlockPos pos2 = PositionUtils.getMaxCorner(posStart, posEnd).func_177982_a(1, 1, 1);
        List existingEntities = world.func_72839_b(null, new AxisAlignedBB(pos1, pos2));
        for (NBTTagCompound tag : this.entities) {
            Entity entity;
            NBTTagList posList = tag.func_150295_c("Pos", 6);
            Vec3d relativePos = new Vec3d(posList.func_150309_d(0), posList.func_150309_d(1), posList.func_150309_d(2));
            Vec3d transformedRelativePos = PositionUtils.getTransformedPosition(relativePos, mirror, rotation);
            Vec3d realPos = transformedRelativePos.func_72441_c((double)posStart.func_177958_n(), (double)posStart.func_177956_o(), (double)posStart.func_177952_p());
            posList = new NBTTagList();
            posList.func_74742_a((NBTBase)new NBTTagDouble(realPos.field_72450_a));
            posList.func_74742_a((NBTBase)new NBTTagDouble(realPos.field_72448_b));
            posList.func_74742_a((NBTBase)new NBTTagDouble(realPos.field_72449_c));
            tag.func_74782_a("Pos", (NBTBase)posList);
            UUID uuidOriginal = tag.func_186857_a("UUID");
            tag.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)tag, (World)world);
            }
            catch (Exception var15) {
                entity = null;
            }
            if (entity == null) continue;
            float rotationYaw = entity.func_184217_a(mirror);
            entity.func_70012_b(realPos.field_72450_a, realPos.field_72448_b, realPos.field_72449_c, rotationYaw += entity.field_70177_z - entity.func_184229_a(rotation), entity.field_70125_A);
            Object existing = EntityUtils.findEntityByUUID(existingEntities, uuidOriginal);
            if (existing != null) {
                world.func_72973_f(existing);
                entity.func_184221_a(uuidOriginal);
            } else if (world instanceof WorldServer && ((WorldServer)world).func_175733_a(uuidOriginal) == null) {
                entity.func_184221_a(uuidOriginal);
            }
            world.func_72838_d(entity);
        }
    }

    public Map<BlockPos, String> getDataStructureBlocks(BlockPos posStart, PlacementSettings placement) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<BlockPos, NBTTagCompound> entry : this.tiles.entrySet()) {
            NBTTagCompound tag = entry.getValue();
            if (!tag.func_74779_i("id").equals("minecraft:structure_block") || TileEntityStructure.Mode.valueOf((String)tag.func_74779_i("mode")) != TileEntityStructure.Mode.DATA) continue;
            BlockPos pos = entry.getKey();
            pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vec3i)posStart);
            map.put(pos, tag.func_74779_i("metadata"));
        }
        return map;
    }

    private void readBlocksFromWorld(World world, BlockPos posStart, BlockPos size, boolean cbCrossWorld) {
        this.size = size;
        int width = size.func_177958_n();
        int height = size.func_177956_o();
        int length = size.func_177952_p();
        int numBlocks = width * height * length;
        int startX = posStart.func_177958_n();
        int startY = posStart.func_177956_o();
        int startZ = posStart.func_177952_p();
        int endX = startX + size.func_177958_n();
        int endY = startY + size.func_177956_o();
        int endZ = startZ + size.func_177952_p();
        int index = 0;
        this.blocks = new IBlockState[numBlocks];
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        this.tiles.clear();
        for (int y = startY; y < endY; ++y) {
            for (int z = startZ; z < endZ; ++z) {
                int x = startX;
                while (x < endX) {
                    posMutable.func_181079_c(x, y, z);
                    this.blocks[index] = world.func_180495_p((BlockPos)posMutable);
                    TileEntity te = world.func_175625_s((BlockPos)posMutable);
                    if (te != null) {
                        try {
                            NBTTagCompound nbt = new NBTTagCompound();
                            nbt = cbCrossWorld ? chiselsAndBitsHandler.writeChiselsAndBitsTileToNBT(nbt, te) : te.func_189515_b(nbt);
                            int relX = x - startX;
                            int relY = y - startY;
                            int relZ = z - startZ;
                            nbt.func_74768_a("x", relX);
                            nbt.func_74768_a("y", relY);
                            nbt.func_74768_a("z", relZ);
                            this.tiles.put(new BlockPos(relX, relY, relZ), nbt);
                        }
                        catch (Exception e) {
                            WorldPrimer.logger.warn("Exception while trying to store TileEntity data for block '{}' at {}", (Object)this.blocks[index], (Object)posMutable.toString(), (Object)e);
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    private void readEntitiesFromWorld(World world, BlockPos posStart, BlockPos size) {
        this.entities.clear();
        List entities = world.func_72839_b(null, new AxisAlignedBB(posStart, posStart.func_177971_a((Vec3i)size)));
        for (Entity entity : entities) {
            NBTTagCompound tag;
            if (!entity.func_70039_c(tag = new NBTTagCompound())) continue;
            NBTTagList posList = new NBTTagList();
            posList.func_74742_a((NBTBase)new NBTTagDouble(entity.field_70165_t - (double)posStart.func_177958_n()));
            posList.func_74742_a((NBTBase)new NBTTagDouble(entity.field_70163_u - (double)posStart.func_177956_o()));
            posList.func_74742_a((NBTBase)new NBTTagDouble(entity.field_70161_v - (double)posStart.func_177952_p()));
            tag.func_74782_a("Pos", (NBTBase)posList);
            this.entities.add(tag);
        }
    }

    public static Schematic createFromWorld(World world, BlockPos posStart, BlockPos size, boolean cbCrossWorld) {
        Schematic schematic = new Schematic();
        schematic.readBlocksFromWorld(world, posStart, size, cbCrossWorld);
        schematic.readEntitiesFromWorld(world, posStart, size);
        return schematic;
    }

    @Nullable
    public static Schematic createFromFile(File file) {
        Schematic schematic = new Schematic();
        if (schematic.readFromFile(file)) {
            return schematic;
        }
        return null;
    }

    public boolean readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Blocks", 7) && nbt.func_150297_b("Data", 7)) {
            short width = nbt.func_74765_d("Width");
            short height = nbt.func_74765_d("Height");
            short length = nbt.func_74765_d("Length");
            byte[] blockIdsByte = nbt.func_74770_j("Blocks");
            byte[] metaArr = nbt.func_74770_j("Data");
            int numBlocks = blockIdsByte.length;
            this.size = new BlockPos((int)width, (int)height, (int)length);
            if (numBlocks != width * height * length) {
                WorldPrimer.logger.error("Schematic: Mismatched block array size compared to the width/height/length, blocks: {}, W x H x L: {} x {} x {}", (Object)numBlocks, (Object)width, (Object)height, (Object)length);
                return false;
            }
            if (numBlocks != metaArr.length) {
                WorldPrimer.logger.error("Schematic: Mismatched block ID and metadata array sizes, blocks: {}, meta: {}", (Object)numBlocks, (Object)metaArr.length);
                return false;
            }
            if (!this.readPalette(nbt)) {
                WorldPrimer.logger.error("Schematic: Failed to read the block palette");
                return false;
            }
            this.blocks = new IBlockState[numBlocks];
            if (nbt.func_150297_b("AddBlocks", 7)) {
                Block block;
                int byteId;
                int addValue;
                int expectedAddLength;
                byte[] add = nbt.func_74770_j("AddBlocks");
                if (add.length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
                    WorldPrimer.logger.error("Schematic: Add array size mismatch, blocks: {}, add: {}, expected add: {}", (Object)numBlocks, (Object)add.length, (Object)expectedAddLength);
                    return false;
                }
                int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
                int bi = 0;
                int ai = 0;
                while (bi < loopMax) {
                    addValue = add[ai] & 0xFF;
                    byteId = blockIdsByte[bi] & 0xFF;
                    block = this.palette[(addValue & 0xF0) << 4 | byteId];
                    this.blocks[bi] = block.func_176203_a((int)metaArr[bi]);
                    byteId = blockIdsByte[bi + 1] & 0xFF;
                    block = this.palette[(addValue & 0xF) << 8 | byteId];
                    this.blocks[bi + 1] = block.func_176203_a((int)metaArr[bi + 1]);
                    bi += 2;
                    ++ai;
                }
                if (numBlocks % 2 != 0) {
                    addValue = add[ai] & 0xFF;
                    byteId = blockIdsByte[bi] & 0xFF;
                    block = this.palette[(addValue & 0xF0) << 4 | byteId];
                    this.blocks[bi] = block.func_176203_a((int)metaArr[bi]);
                }
            } else {
                if (nbt.func_150297_b("Add", 7)) {
                    WorldPrimer.logger.error("Schematic: Old Schematica format detected, not currently implemented...");
                    return false;
                }
                for (int i = 0; i < numBlocks; ++i) {
                    Block block = this.palette[blockIdsByte[i] & 0xFF];
                    this.blocks[i] = block.func_176203_a((int)metaArr[i]);
                }
            }
            this.readEntities(nbt);
            this.readTileEntities(nbt);
            return true;
        }
        WorldPrimer.logger.error("Schematic: Missing block data in the schematic '{}'", (Object)this.fileName);
        return false;
    }

    private boolean readPalette(NBTTagCompound nbt) {
        Block air = Blocks.field_150350_a;
        this.palette = new Block[4096];
        Arrays.fill(this.palette, air);
        if (nbt.func_150297_b("SchematicaMapping", 10)) {
            NBTTagCompound tag = nbt.func_74775_l("SchematicaMapping");
            Set keys = tag.func_150296_c();
            for (String key : keys) {
                short id = tag.func_74765_d(key);
                if (id >= this.palette.length) {
                    WorldPrimer.logger.error("Schematic: Invalid ID '{}' in SchematicaMapping for block '{}', max = 4095", (Object)id, (Object)key);
                    return false;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    this.palette[id] = block;
                    continue;
                }
                WorldPrimer.logger.error("Schematic: Missing/non-existing block '{}' in SchematicaMapping", (Object)key);
            }
        } else if (nbt.func_150297_b("BlockIDs", 10)) {
            NBTTagCompound tag = nbt.func_74775_l("BlockIDs");
            Set keys = tag.func_150296_c();
            for (String idStr : keys) {
                int id;
                String key = tag.func_74779_i(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    WorldPrimer.logger.error("Schematic: Invalid ID '{}' (not a number) in MCEdit2 palette for block '{}'", (Object)idStr, (Object)key);
                    continue;
                }
                if (id >= this.palette.length) {
                    WorldPrimer.logger.error("Schematic: Invalid ID '{}' in MCEdit2 palette for block '{}', max = 4095", (Object)id, (Object)key);
                    return false;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    this.palette[id] = block;
                    continue;
                }
                WorldPrimer.logger.error("Schematic: Missing/non-existing block '{}' in MCEdit2 palette", (Object)key);
            }
        } else {
            for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
                if (block == null) continue;
                int id = Block.func_149682_b((Block)block);
                if (id >= 0 && id < this.palette.length) {
                    this.palette[id] = block;
                    continue;
                }
                WorldPrimer.logger.error("Schematic: Invalid ID {} for block '{}' from the registry", (Object)id, (Object)block.getRegistryName());
            }
        }
        return true;
    }

    private void readEntities(NBTTagCompound nbt) {
        this.entities.clear();
        NBTTagList tagList = nbt.func_150295_c("Entities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.entities.add(tagList.func_150305_b(i));
        }
    }

    private void readTileEntities(NBTTagCompound nbt) {
        this.tiles.clear();
        NBTTagList tagList = nbt.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            this.tiles.put(pos, tag);
        }
    }

    public boolean readFromFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            this.fileName = file.getName();
            try {
                FileInputStream is = new FileInputStream(file);
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)is);
                is.close();
                return this.readFromNBT(nbt);
            }
            catch (IOException e) {
                WorldPrimer.logger.error("Schematic: Failed to read Schematic data from file '{}'", (Object)file.getAbsolutePath());
            }
        }
        return false;
    }

    private void createPalette() {
        if (this.palette == null) {
            this.palette = new Block[4096];
            int numBlocks = this.blocks.length;
            for (int i = 0; i < numBlocks; ++i) {
                Block block = this.blocks[i].func_177230_c();
                int id = Block.func_149682_b((Block)block);
                if (id >= this.palette.length) {
                    throw new IllegalArgumentException(String.format("Block id %d for block '%s' is out of range, max allowed = %d!", id, this.blocks[i].toString(), this.palette.length - 1));
                }
                this.palette[id] = block;
            }
        }
    }

    private void writePaletteToNBT(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < this.palette.length; ++i) {
            ResourceLocation rl;
            Block block = this.palette[i];
            if (block == null || (rl = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)) == null) continue;
            tag.func_74777_a(rl.toString(), (short)(i & 0xFFF));
        }
        nbt.func_74782_a("SchematicaMapping", (NBTBase)tag);
    }

    private void writeBlocksToNBT(NBTTagCompound nbt) {
        nbt.func_74777_a("Width", (short)this.size.func_177958_n());
        nbt.func_74777_a("Height", (short)this.size.func_177956_o());
        nbt.func_74777_a("Length", (short)this.size.func_177952_p());
        nbt.func_74778_a("Materials", "Alpha");
        int numBlocks = this.blocks.length;
        int loopMax = (int)Math.floor((double)numBlocks / 2.0);
        int addSize = (int)Math.ceil((double)numBlocks / 2.0);
        byte[] blockIdsArr = new byte[numBlocks];
        byte[] metaArr = new byte[numBlocks];
        byte[] addArr = new byte[addSize];
        int numAdd = 0;
        int bi = 0;
        int ai = 0;
        while (ai < loopMax) {
            IBlockState state1 = this.blocks[bi];
            IBlockState state2 = this.blocks[bi + 1];
            int id1 = Block.func_149682_b((Block)state1.func_177230_c());
            int id2 = Block.func_149682_b((Block)state2.func_177230_c());
            int add = id1 >>> 4 & 0xF0 | id2 >>> 8 & 0xF;
            blockIdsArr[bi] = (byte)(id1 & 0xFF);
            blockIdsArr[bi + 1] = (byte)(id2 & 0xFF);
            if (add != 0) {
                addArr[ai] = (byte)add;
                ++numAdd;
            }
            metaArr[bi] = (byte)state1.func_177230_c().func_176201_c(state1);
            metaArr[bi + 1] = (byte)state2.func_177230_c().func_176201_c(state2);
            ++ai;
            bi += 2;
        }
        if (numBlocks % 2 != 0) {
            IBlockState state = this.blocks[bi];
            int id = Block.func_149682_b((Block)state.func_177230_c());
            int add = id >>> 4 & 0xF0;
            blockIdsArr[bi] = (byte)(id & 0xFF);
            if (add != 0) {
                addArr[ai] = (byte)add;
                ++numAdd;
            }
            metaArr[bi] = (byte)state.func_177230_c().func_176201_c(state);
        }
        nbt.func_74773_a("Blocks", blockIdsArr);
        nbt.func_74773_a("Data", metaArr);
        if (numAdd > 0) {
            nbt.func_74773_a("AddBlocks", addArr);
        }
    }

    private NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.createPalette();
        this.writeBlocksToNBT(nbt);
        this.writePaletteToNBT(nbt);
        NBTTagList tagListTiles = new NBTTagList();
        NBTTagList tagListEntities = new NBTTagList();
        for (NBTTagCompound tag : this.entities) {
            tagListEntities.func_74742_a((NBTBase)tag);
        }
        for (NBTTagCompound tag : this.tiles.values()) {
            tagListTiles.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("TileEntities", (NBTBase)tagListTiles);
        nbt.func_74782_a("Entities", (NBTBase)tagListEntities);
        return nbt;
    }

    public boolean writeToFile(File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(), (OutputStream)os);
            os.close();
            return true;
        }
        catch (IOException e) {
            WorldPrimer.logger.error("Schematic: Failed to write Schematic data to file '{}'", (Object)file.getAbsolutePath());
            return false;
        }
    }

    public static class ChiselsAndBitsHandler {
        public boolean isChiselsAndBitsTile(TileEntity te) {
            return false;
        }

        public NBTTagCompound writeChiselsAndBitsTileToNBT(NBTTagCompound tag, TileEntity te) {
            return te.func_189515_b(tag);
        }
    }
}

