/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.command;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.command.CommandWorldPrimer;
import fi.dy.masa.worldprimer.command.SubCommandPlaceStructure;
import fi.dy.masa.worldprimer.config.Configs;
import fi.dy.masa.worldprimer.util.PositionUtils;
import fi.dy.masa.worldprimer.util.Schematic;
import fi.dy.masa.worldprimer.util.TemplateWorldPrimer;
import fi.dy.masa.worldprimer.util.WorldUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.io.IOUtils;

public class SubCommandCreateStructure
extends SubCommandPlaceStructure {
    public SubCommandCreateStructure(CommandWorldPrimer baseCommand) {
        super(baseCommand);
    }

    @Override
    public String getName() {
        return "create-structure";
    }

    @Override
    public void printHelpGeneric(ICommandSender sender) {
        this.sendMessage(sender, this.getUsage(), new Object[0]);
    }

    private String getUsage() {
        return this.getUsageStringCommon() + " <x1> <y1> <z1> <x2> <y2> <z2> <vanilla | schematic> <structurename> [override]";
    }

    @Override
    protected List<String> getTabCompletionsSub(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length <= 3) {
            return CommandBase.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
        }
        if (args.length <= 6) {
            return CommandBase.func_175771_a((String[])args, (int)3, (BlockPos)targetPos);
        }
        if (args.length == 7) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"vanilla", "schematic"});
        }
        if (args.length == 8) {
            return CommandBase.func_175762_a((String[])args, this.getExistingStructureFileNames());
        }
        if (args.length == 9) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"override"});
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 8 && args.length <= 9) {
            if (!args[6].equals("schematic") && !args[6].equals("vanilla")) {
                SubCommandCreateStructure.throwUsage(this.getUsage(), new Object[0]);
            }
            SubCommandPlaceStructure.StructureType type = args[6].equals("schematic") ? SubCommandPlaceStructure.StructureType.SCHEMATIC : SubCommandPlaceStructure.StructureType.STRUCTURE;
            boolean override = args.length == 9 && args[8].equals("override");
            String fileName = args[7];
            File file = new File(this.getStructureDirectory(), fileName + type.getExtension());
            if (!override && file.exists()) {
                SubCommandCreateStructure.throwCommand("worldprimer.commands.error.create_schematic.file_exists_no_override", file.getAbsolutePath());
            }
            try {
                BlockPos pos1 = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
                BlockPos pos2 = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)3, (boolean)false);
                BlockPos posStart = PositionUtils.getMinCorner(pos1, pos2);
                BlockPos posEnd = PositionUtils.getMaxCorner(pos1, pos2);
                BlockPos size = posEnd.func_177973_b((Vec3i)posStart).func_177982_a(1, 1, 1);
                World world = sender.func_130014_f_();
                boolean cbCrossWorld = Configs.enableChiselsAndBitsCrossWorldFormat;
                WorldUtils.loadBlocks(world, posStart.func_177958_n(), posStart.func_177952_p(), posEnd.func_177958_n(), posEnd.func_177952_p());
                if (cbCrossWorld) {
                    WorldPrimer.logger.info("Using a cross-world compatible format for any Chisels & Bits blocks");
                }
                if (this.tryCreateSchematicWrapper(server, world, posStart, size, type, fileName, cbCrossWorld, sender)) {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this.getBaseCommand(), (String)"worldprimer.commands.info.create_schematic.success", (Object[])new Object[]{fileName});
                } else {
                    SubCommandCreateStructure.throwCommand("worldprimer.commands.error.create_schematic.failed", new Object[0]);
                }
                WorldUtils.unloadLoadedChunks(world);
            }
            catch (NumberInvalidException e) {
                SubCommandCreateStructure.throwUsage(this.getUsage(), new Object[0]);
            }
        } else {
            SubCommandCreateStructure.throwUsage(this.getUsage(), new Object[0]);
        }
    }

    private boolean tryCreateSchematicWrapper(MinecraftServer server, World world, BlockPos posStart, BlockPos size, SubCommandPlaceStructure.StructureType type, String structureName, boolean cbCrossWorld, ICommandSender sender) throws CommandException {
        if (type == SubCommandPlaceStructure.StructureType.STRUCTURE) {
            return this.tryCreateVanillaStructure(server, world, posStart, size, structureName, cbCrossWorld, sender);
        }
        if (type == SubCommandPlaceStructure.StructureType.SCHEMATIC) {
            return this.tryCreateSchematic(server, world, posStart, size, structureName, cbCrossWorld, sender);
        }
        return false;
    }

    private boolean tryCreateVanillaStructure(MinecraftServer server, World world, BlockPos posStart, BlockPos size, String fileName, boolean cbCrossWorld, ICommandSender sender) throws CommandException {
        TemplateWorldPrimer template = cbCrossWorld ? new TemplateWorldPrimer() : new Template();
        template.func_186254_a(world, posStart, size, true, Blocks.field_189881_dj);
        template.func_186252_a(sender.func_70005_c_());
        return this.writeTemplateToFile(template, fileName);
    }

    private boolean tryCreateSchematic(MinecraftServer server, World world, BlockPos posStart, BlockPos size, String structureName, boolean cbCrossWorld, ICommandSender sender) throws CommandException {
        File dir = this.getStructureDirectory();
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        File file = new File(dir, structureName + SubCommandPlaceStructure.StructureType.SCHEMATIC.getExtension());
        Schematic schematic = Schematic.createFromWorld(world, posStart, size, cbCrossWorld);
        return schematic.writeToFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeTemplateToFile(Template template, String structureName) {
        boolean bl;
        File dir = this.getStructureDirectory();
        if (!dir.exists() && !dir.mkdirs()) {
            WorldPrimer.logger.warn("Failed to create structure directory '{}'", (Object)dir.getAbsolutePath());
            return false;
        }
        File file = new File(dir, structureName + SubCommandPlaceStructure.StructureType.STRUCTURE.getExtension());
        FileOutputStream os = null;
        try {
            NBTTagCompound nbt = template.func_189552_a(new NBTTagCompound());
            os = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)os);
            bl = true;
        }
        catch (Throwable t) {
            try {
                WorldPrimer.logger.warn("Failed to write structure data to file '{}'", (Object)file.getAbsolutePath(), (Object)t);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
            return false;
        }
        IOUtils.closeQuietly((OutputStream)os);
        return bl;
    }
}

