/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer;

import fi.dy.masa.worldprimer.command.CommandWorldPrimer;
import fi.dy.masa.worldprimer.command.WorldPrimerCommandSender;
import fi.dy.masa.worldprimer.config.Configs;
import fi.dy.masa.worldprimer.proxy.IProxy;
import fi.dy.masa.worldprimer.util.CommandSubstitutions;
import fi.dy.masa.worldprimer.util.DataTracker;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="worldprimer", name="World Primer", version="0.6.0-dev.20190814.220944", certificateFingerprint="2b03e1423915a189b8094816baa18f239d576dff", guiFactory="fi.dy.masa.worldprimer.config.WorldPrimerGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/worldprimer/master/update.json", acceptableRemoteVersions="*", acceptedMinecraftVersions="1.12")
public class WorldPrimer {
    @Mod.Instance(value="worldprimer")
    public static WorldPrimer instance;
    @SidedProxy(clientSide="fi.dy.masa.worldprimer.proxy.ClientProxy", serverSide="fi.dy.masa.worldprimer.proxy.CommonProxy")
    public static IProxy proxy;
    public static final Logger logger;
    public static String configDirPath;
    public static CommandWorldPrimer commandWorldPrimer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configs.loadConfigsFromFile(event.getSuggestedConfigurationFile());
        configDirPath = new File(event.getModConfigurationDirectory(), "worldprimer").getAbsolutePath();
        commandWorldPrimer = new CommandWorldPrimer();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        WorldPrimer.logInfo("FMLServerAboutToStartEvent", new Object[0]);
        Configs.loadConfigsFromFile();
        File worldDir = new File(((AnvilSaveConverter)event.getServer().func_71254_M()).field_75808_a, event.getServer().func_71270_I());
        if (Configs.enableDataTracking) {
            DataTracker.instance().readFromDisk(worldDir);
            int count = DataTracker.instance().getServerStartCount();
            WorldPrimer.logInfo("FMLServerAboutToStartEvent - server starting, previous start count: {}", count);
            if (Configs.enableEarlyWorldCreationCommands && count == 0) {
                WorldPrimer.logInfo("FMLServerAboutToStartEvent - running earlyWorldCreationCommands", new Object[0]);
                WorldPrimerCommandSender.instance().runCommands(null, Configs.earlyWorldCreationCommands);
            }
        }
        if (Configs.enableEarlyWorldLoadingCommands) {
            WorldPrimer.logInfo("FMLServerAboutToStartEvent - running earlyWorldLoadingCommands", new Object[0]);
            WorldPrimerCommandSender.instance().runCommands(null, Configs.earlyWorldLoadingCommands);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        WorldPrimer.logInfo("FMLServerStartingEvent", new Object[0]);
        event.registerServerCommand((ICommand)commandWorldPrimer);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        WorldPrimer.logInfo("FMLServerStartedEvent", new Object[0]);
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0];
        if (Configs.enableDataTracking && Configs.enablePostWorldCreationCommands && DataTracker.instance().getServerStartCount() == 0) {
            WorldPrimer.logInfo("FMLServerStartedEvent - running postWorldCreationCommands", new Object[0]);
            WorldPrimerCommandSender.instance().runCommands((World)world, Configs.postWorldCreationCommands);
        }
        DataTracker.instance().serverStarted();
        if (Configs.enablePostWorldLoadingCommands) {
            WorldPrimer.logInfo("FMLServerStartedEvent - running postWorldLoadingCommands", new Object[0]);
            WorldPrimerCommandSender.instance().runCommands((World)world, Configs.postWorldLoadingCommands);
        }
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppingEvent event) {
        WorldPrimer.logInfo("FMLServerStoppingEvent", new Object[0]);
        CommandSubstitutions.clearTopYCache();
    }

    public static void logInfo(String message, Object ... params) {
        if (Configs.enableLoggingInfo) {
            logger.info(message, params);
        } else {
            logger.debug(message, params);
        }
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            logger.warn("*********************************************************************************************");
            logger.warn("*****                                    WARNING                                        *****");
            logger.warn("*****                                                                                   *****");
            logger.warn("*****   The signature of the mod file '{}' does not match the expected fingerprint!     *****", (Object)event.getSource().getName());
            logger.warn("*****   This might mean that the mod file has been tampered with!                       *****");
            logger.warn("*****   If you did not download the mod {} directly from Curse/CurseForge,       *****", (Object)"World Primer");
            logger.warn("*****   or using one of the well known launchers, and you did not                       *****");
            logger.warn("*****   modify the mod file at all yourself, then it's possible,                        *****");
            logger.warn("*****   that it may contain malware or other unwanted things!                           *****");
            logger.warn("*********************************************************************************************");
        }
    }

    static {
        logger = LogManager.getLogger((String)"worldprimer");
    }
}

