/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.darksteel.anvil;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.config.config.BaseConfig;
import crazypants.enderio.base.material.alloy.Alloy;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio")
public class BlockBrokenAnvil
extends BlockFalling {
    private static final double px = 0.0625;
    @Nonnull
    protected static final AxisAlignedBB SHAPE = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.28125, 0.9375);

    public static BlockBrokenAnvil create(@Nonnull IModObject modObject) {
        return new BlockBrokenAnvil(modObject);
    }

    BlockBrokenAnvil(@Nonnull IModObject modObject) {
        super(Material.field_151574_g);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185858_k);
        this.func_149752_b(((Float)BaseConfig.explosionResistantBlockHardness.get()).floatValue());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockAnvil.field_176506_a, (Comparable)EnumFacing.NORTH));
        this.func_149713_g(0);
        modObject.apply(this);
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return SHAPE;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockAnvil.field_176506_a, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)BlockAnvil.field_176506_a)).func_176736_b();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockAnvil.field_176506_a});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        int totalValue = 279;
        totalValue = (int)((float)totalValue * 0.75f * RANDOM.nextFloat() + (float)totalValue * 0.25f);
        int blocks = 0;
        int ingots = 0;
        int nuggets = 0;
        while (totalValue > 0) {
            if (RANDOM.nextBoolean()) {
                ++nuggets;
                --totalValue;
                continue;
            }
            if (totalValue >= 9 && RANDOM.nextBoolean()) {
                ++ingots;
                totalValue -= 9;
                continue;
            }
            if (totalValue >= 81 && RANDOM.nextBoolean()) {
                ++blocks;
                totalValue -= 81;
                continue;
            }
            ++nuggets;
            --totalValue;
        }
        if (blocks > 0) {
            drops.add((Object)Alloy.DARK_STEEL.getStackBlock(blocks));
        }
        while (ingots > 0) {
            drops.add((Object)Alloy.DARK_STEEL.getStackIngot(ingots > 64 ? 64 : ingots));
            ingots -= 64;
        }
        while (nuggets > 0) {
            drops.add((Object)Alloy.DARK_STEEL.getStackNugget(nuggets > 64 ? 64 : nuggets));
            nuggets -= 64;
        }
    }
}

