/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;

public class Utils {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static List<List<ItemStack>> copyItemStackList(List<List<ItemStack>> list) {
        ArrayList<List<ItemStack>> itemStackListCopy = new ArrayList<List<ItemStack>>();
        for (List<ItemStack> stackList : list) {
            itemStackListCopy.add(Utils.copyItemStack(stackList));
        }
        return itemStackListCopy;
    }

    public static List<ItemStack> copyItemStack(List<ItemStack> stack) {
        ArrayList<ItemStack> stackListCopy = new ArrayList<ItemStack>();
        for (ItemStack stackCopy : stack) {
            stackListCopy.add(stackCopy.func_77946_l());
        }
        return stackListCopy;
    }

    public static boolean areItemStacksEqualIgnoreSize(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            if (stackA.func_77973_b() != stackB.func_77973_b()) {
                return false;
            }
            if (stackA.func_77952_i() != stackB.func_77952_i()) {
                return false;
            }
            return ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB) && stackA.areCapsCompatible(stackB);
        }
        return false;
    }

    public static boolean areItemStackListsEqualIgnoreSize(List<List<ItemStack>> stackA, List<List<ItemStack>> stackB) {
        if (stackA.size() != stackB.size()) {
            return false;
        }
        for (int i = 0; i < stackA.size(); ++i) {
            if (stackA.get(i).size() == 0 || stackB.size() == 0) {
                return false;
            }
            if (Utils.areItemStacksEqualIgnoreSize(stackA.get(i).get(0), stackB.get(i).get(0))) continue;
            return false;
        }
        return true;
    }

    public static int clamp(int n, int min, int max) {
        return Math.max(min, Math.min(max, n));
    }

    public static String formatLong(long value) {
        if (value == Long.MIN_VALUE) {
            return Utils.formatLong(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + Utils.formatLong(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static <T> boolean arrayContains(T[] array, T item) {
        for (T arrayItem : array) {
            if (!arrayItem.equals(item)) continue;
            return true;
        }
        return false;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

