/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.util;

import com.eightbitforest.thebomplugin.TheBOMPluginMod;
import com.eightbitforest.thebomplugin.util.CachedRecipe;
import com.eightbitforest.thebomplugin.util.ItemStackComparator;
import com.eightbitforest.thebomplugin.util.Recipes;
import com.eightbitforest.thebomplugin.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BOMCalculator {
    private static List<CachedRecipe> cachedRecipes = new ArrayList<CachedRecipe>();
    private static List<CachedRecipe> finalCachedRecipes = new ArrayList<CachedRecipe>();
    private static final ItemStackComparator itemStackComparator = new ItemStackComparator();

    private BOMCalculator() {
    }

    public static List<List<ItemStack>> getBaseIngredients(IIngredients recipe) {
        return BOMCalculator.getBaseIngredients(recipe, 1);
    }

    public static List<List<ItemStack>> getBaseIngredients(IIngredients recipe, int outputAmount) {
        try {
            CachedRecipe finalCachedRecipe;
            List output = (List)recipe.getOutputs(ItemStack.class).get(0);
            ArrayList<List<ItemStack>> baseIngredients = new ArrayList();
            ArrayList<List<ItemStack>> extraOutputs = new ArrayList<List<ItemStack>>();
            if (outputAmount == 1 && (finalCachedRecipe = BOMCalculator.findFinalCachedRecipe(recipe)) != null) {
                baseIngredients = finalCachedRecipe.getBaseIngredients();
                return baseIngredients;
            }
            for (List recipeItem : recipe.getInputs(ItemStack.class)) {
                for (int i = 0; i < outputAmount; ++i) {
                    ArrayList<List<ItemStack>> seenItems = new ArrayList<List<ItemStack>>(Collections.singletonList(output));
                    BOMCalculator.addToIngredients(baseIngredients, BOMCalculator.getBaseIngredientsForItem(recipeItem, seenItems, extraOutputs));
                }
            }
            cachedRecipes.add(new CachedRecipe(baseIngredients, output, extraOutputs));
            BOMCalculator.utilizeExtraOutputs(baseIngredients, extraOutputs);
            baseIngredients.sort(itemStackComparator);
            finalCachedRecipes.add(new CachedRecipe(recipe, baseIngredients, output, extraOutputs));
            return baseIngredients;
        }
        catch (StackOverflowError e) {
            System.out.println("TheBOMPlugin: ERROR. StackOverFlow while processing: " + ((ItemStack)((List)recipe.getOutputs(ItemStack.class).get(0)).get(0)).func_77977_a());
            System.out.println("Recipe:");
            for (List ingredient : recipe.getInputs(ItemStack.class)) {
                ((ItemStack)ingredient.get(0)).func_77977_a();
            }
            e.printStackTrace();
            finalCachedRecipes.add(new CachedRecipe(recipe, recipe.getInputs(ItemStack.class), (List)recipe.getOutputs(ItemStack.class).get(0), new ArrayList<List<ItemStack>>()));
            return recipe.getInputs(ItemStack.class);
        }
    }

    private static List<List<ItemStack>> getBaseIngredientsForItem(List<ItemStack> stack, List<List<ItemStack>> seenItems, List<List<ItemStack>> extraOutputs) {
        ArrayList<List<ItemStack>> baseIngredients = new ArrayList<List<ItemStack>>();
        if (stack.size() == 0) {
            return baseIngredients;
        }
        if (BOMCalculator.isBaseItem(stack)) {
            BOMCalculator.addItemStack(baseIngredients, stack);
            return baseIngredients;
        }
        CachedRecipe cachedRecipe = BOMCalculator.findCachedRecipe(stack);
        if (cachedRecipe != null) {
            BOMCalculator.addToIngredients(extraOutputs, cachedRecipe.getExtraOutputs());
            BOMCalculator.addToIngredients(baseIngredients, cachedRecipe.getBaseIngredients());
            return baseIngredients;
        }
        if (seenItems.size() > 512) {
            BOMCalculator.addItemStack(baseIngredients, stack);
            return baseIngredients;
        }
        for (List<ItemStack> item : seenItems) {
            if (!item.equals(stack)) continue;
            BOMCalculator.addItemStack(baseIngredients, stack);
            return baseIngredients;
        }
        List<IIngredients> recipes = Recipes.getRecipesForItemStack(stack.get(0));
        IIngredients chosenRecipe = BOMCalculator.pickBestRecipe(recipes);
        if (chosenRecipe == null) {
            BOMCalculator.addItemStack(baseIngredients, stack);
            return baseIngredients;
        }
        for (List<ItemStack> item : seenItems) {
            for (List recipeItem : chosenRecipe.getInputs(ItemStack.class)) {
                if (recipeItem.size() == 0 || !Utils.areItemStacksEqualIgnoreSize((ItemStack)recipeItem.get(0), item.get(0))) continue;
                BOMCalculator.addItemStack(baseIngredients, item);
                return baseIngredients;
            }
        }
        ArrayList<List<ItemStack>> newExtraOutputs = new ArrayList<List<ItemStack>>();
        List recipeOutput = (List)chosenRecipe.getOutputs(ItemStack.class).get(0);
        if (((ItemStack)recipeOutput.get(0)).func_190916_E() > 1) {
            ArrayList<ItemStack> extraStack = new ArrayList<ItemStack>(Collections.singletonList(((ItemStack)recipeOutput.get(0)).func_77946_l()));
            BOMCalculator.decreaseStackCount(extraStack);
            BOMCalculator.addToIngredients(newExtraOutputs, new ArrayList<List<ItemStack>>(Collections.singletonList(extraStack)));
        }
        for (List recipeItem : chosenRecipe.getInputs(ItemStack.class)) {
            if (recipeItem.size() == 0) continue;
            ArrayList<List<ItemStack>> newSeenItems = new ArrayList<List<ItemStack>>(seenItems);
            newSeenItems.add(stack);
            BOMCalculator.addToIngredients(baseIngredients, BOMCalculator.getBaseIngredientsForItem(recipeItem, newSeenItems, newExtraOutputs));
        }
        cachedRecipes.add(new CachedRecipe(baseIngredients, recipeOutput, newExtraOutputs));
        BOMCalculator.addToIngredients(extraOutputs, newExtraOutputs);
        return baseIngredients;
    }

    private static void utilizeExtraOutputs(List<List<ItemStack>> baseIngredients, List<List<ItemStack>> extraOutputs) {
        BOMCalculator.purgeAirFromExtraOutputs(extraOutputs);
        List<List<ItemStack>> extraOutputsCopy = Utils.copyItemStackList(extraOutputs);
        for (List<ItemStack> extraOutputCopy : extraOutputsCopy) {
            List<ItemStack> extraOutput = BOMCalculator.findIngredientInList(extraOutputs, extraOutputCopy);
            if (extraOutput == null || extraOutput.get(0).func_190916_E() <= 0) continue;
            if (BOMCalculator.isBaseItem(extraOutput)) {
                int numToDecrease = extraOutput.get(0).func_190916_E();
                for (int i = 0; i < numToDecrease; ++i) {
                    List<ItemStack> ingredient = BOMCalculator.findIngredientInList(baseIngredients, extraOutput);
                    BOMCalculator.decreaseStackCount(ingredient);
                    BOMCalculator.decreaseStackCount(extraOutput);
                }
                continue;
            }
            List<IIngredients> recipes = Recipes.getRecipesForItemStack(extraOutput.get(0));
            IIngredients extraOutputRecipe = BOMCalculator.pickBestRecipe(recipes);
            if (extraOutputRecipe != null) {
                int numberOfExtras = extraOutput.get(0).func_190916_E() / ((ItemStack)((List)extraOutputRecipe.getOutputs(ItemStack.class).get(0)).get(0)).func_190916_E();
                if (numberOfExtras <= 0) continue;
                for (int i = 0; i < numberOfExtras * ((ItemStack)((List)extraOutputRecipe.getOutputs(ItemStack.class).get(0)).get(0)).func_190916_E(); ++i) {
                    BOMCalculator.decreaseStackCount(extraOutput);
                }
                for (List extraOutputRecipeItem : extraOutputRecipe.getInputs(ItemStack.class)) {
                    if (extraOutputRecipeItem.size() <= 0) continue;
                    List<ItemStack> extraOutputRecipeItemCopy = Utils.copyItemStack(extraOutputRecipeItem);
                    extraOutputRecipeItemCopy.forEach(stack -> stack.func_190920_e(numberOfExtras));
                    BOMCalculator.addToIngredients(extraOutputs, Collections.singletonList(extraOutputRecipeItemCopy));
                    BOMCalculator.utilizeExtraOutputs(baseIngredients, extraOutputs);
                }
                continue;
            }
            int numToDecrease = extraOutput.get(0).func_190916_E();
            for (int i = 0; i < numToDecrease; ++i) {
                List<ItemStack> ingredient = BOMCalculator.findIngredientInList(baseIngredients, extraOutput);
                BOMCalculator.decreaseStackCount(ingredient);
                BOMCalculator.decreaseStackCount(extraOutput);
            }
        }
    }

    private static void purgeAirFromExtraOutputs(List<List<ItemStack>> extraOutputs) {
        extraOutputs.removeIf(next -> next.size() == 0 || ((ItemStack)next.get(0)).func_190916_E() <= 0);
    }

    private static List<ItemStack> findIngredientInList(List<List<ItemStack>> ingredients, List<ItemStack> toFind) {
        for (List<ItemStack> ingredient : ingredients) {
            if (!Utils.areItemStacksEqualIgnoreSize(ingredient.get(0), toFind.get(0)) || ingredient.get(0).func_190916_E() <= 0) continue;
            return ingredient;
        }
        return null;
    }

    private static CachedRecipe findCachedRecipe(List<ItemStack> output) {
        for (CachedRecipe cachedRecipe : cachedRecipes) {
            if (!Utils.areItemStacksEqualIgnoreSize(cachedRecipe.getOutput().get(0), output.get(0))) continue;
            return cachedRecipe;
        }
        return null;
    }

    private static CachedRecipe findFinalCachedRecipe(IIngredients recipe) {
        List output = (List)recipe.getOutputs(ItemStack.class).get(0);
        List inputs = recipe.getInputs(ItemStack.class);
        for (CachedRecipe cachedRecipe : finalCachedRecipes) {
            List cachedInputs = cachedRecipe.getInputs().getInputs(ItemStack.class);
            if (!Utils.areItemStacksEqualIgnoreSize(cachedRecipe.getOutput().get(0), (ItemStack)output.get(0)) || !Utils.areItemStackListsEqualIgnoreSize(cachedInputs, inputs)) continue;
            return cachedRecipe;
        }
        return null;
    }

    private static void decreaseStackCount(List<ItemStack> stack) {
        for (ItemStack item : stack) {
            item.func_190920_e(item.func_190916_E() - 1);
        }
    }

    private static IIngredients pickBestRecipe(List<IIngredients> recipes) {
        for (IIngredients recipe : recipes) {
            boolean validRecipe = true;
            if (BOMCalculator.isBlockRecipe(recipe) || BOMCalculator.isNuggetRecipe(recipe)) continue;
            for (List item : recipe.getInputs(ItemStack.class)) {
                if (!validRecipe) break;
                if (item.size() == 0 || !BOMCalculator.doesItemMatchConfigList(TheBOMPluginMod.getInstance().getConfig().recipeItemBlacklist, (ItemStack)item.get(0))) continue;
                validRecipe = false;
            }
            if (!validRecipe) continue;
            return recipe;
        }
        return null;
    }

    private static boolean doesItemMatchConfigList(List<String> configList, ItemStack stack) {
        for (String configItem : configList) {
            String[] configParts = configItem.split("@");
            if (!stack.func_77973_b().getRegistryName().toString().matches(configParts[0])) continue;
            if (configParts.length == 2) {
                if (!Integer.toString(stack.func_77952_i()).matches(configParts[1])) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static boolean isBlockRecipe(IIngredients recipe) {
        List stack = null;
        for (List recipeItem : recipe.getInputs(ItemStack.class)) {
            if (stack == null && recipeItem.size() != 0) {
                stack = recipeItem;
                continue;
            }
            if (recipeItem.size() == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean isNuggetRecipe(IIngredients recipe) {
        List stack = null;
        if (((ItemStack)((List)recipe.getOutputs(ItemStack.class).get(0)).get(0)).func_190916_E() != 1) {
            return false;
        }
        for (List recipeItem : recipe.getInputs(ItemStack.class)) {
            if (recipeItem.size() == 0) {
                return false;
            }
            if (stack == null) {
                stack = recipeItem;
                continue;
            }
            if (Utils.areItemStacksEqualIgnoreSize((ItemStack)recipeItem.get(0), (ItemStack)stack.get(0))) continue;
            return false;
        }
        return true;
    }

    private static boolean isBaseItem(List<ItemStack> item) {
        if (item.size() > 1) {
            return true;
        }
        return BOMCalculator.doesItemMatchConfigList(TheBOMPluginMod.getInstance().getConfig().baseItems, item.get(0));
    }

    private static void addToIngredients(List<List<ItemStack>> ingredients, List<List<ItemStack>> ingredientsToAdd) {
        for (List<ItemStack> stack : ingredientsToAdd) {
            BOMCalculator.addItemStack(ingredients, stack);
        }
    }

    private static void addItemStack(List<List<ItemStack>> stacks, List<ItemStack> stackToAdd) {
        for (List<ItemStack> stack : stacks) {
            if (!Utils.areItemStacksEqualIgnoreSize(stack.get(0), stackToAdd.get(0))) continue;
            for (ItemStack oreDictStack : stack) {
                oreDictStack.func_190920_e(oreDictStack.func_190916_E() + stackToAdd.get(0).func_190916_E());
            }
            return;
        }
        ArrayList<ItemStack> stackToAddCopy = new ArrayList<ItemStack>(stackToAdd.size());
        for (ItemStack stack : stackToAdd) {
            stackToAddCopy.add(stack.func_77946_l());
        }
        stacks.add(stackToAddCopy);
    }
}

