/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.plugin;

import com.eightbitforest.thebomplugin.TheBOMPlugin;
import com.eightbitforest.thebomplugin.gui.ItemListGui;
import com.eightbitforest.thebomplugin.gui.button.GuiIconButton;
import com.eightbitforest.thebomplugin.jei.ingredients.Ingredients;
import com.eightbitforest.thebomplugin.plugin.BOMRecipe;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class BOMWrapper
implements ICraftingRecipeWrapper {
    private BOMRecipe recipe;
    private IJeiHelpers jeiHelpers;
    private GuiButton hudListButton;
    private GuiButton increaseOutputButton;
    private GuiButton decreaseOutputButton;
    private String trackString;
    private String untrackString;

    public BOMWrapper(BOMRecipe recipe, IJeiHelpers helpers) {
        this.recipe = recipe;
        this.jeiHelpers = helpers;
        this.hudListButton = new GuiButton(0, 109, 90, 55, 20, "");
        this.increaseOutputButton = new GuiIconButton(1, 95, 90, 10, 20, TheBOMPlugin.getInstance().getGuiDrawables().getArrowNext());
        this.decreaseOutputButton = new GuiIconButton(2, 57, 90, 10, 20, TheBOMPlugin.getInstance().getGuiDrawables().getArrowPrevious());
        this.updateDecreaseButton();
        this.trackString = I18n.func_135052_a((String)"button.track.name", (Object[])new Object[0]);
        this.untrackString = I18n.func_135052_a((String)"button.untrack.name", (Object[])new Object[0]);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.recipe.inputs);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.hudListButton.field_146126_j = ItemListGui.isGuiOpen() ? this.untrackString : this.trackString;
        this.hudListButton.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
        this.increaseOutputButton.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
        this.decreaseOutputButton.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (this.hudListButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.hudListButton.func_146113_a(minecraft.func_147118_V());
            if (ItemListGui.isGuiOpen()) {
                ItemListGui.dismissItems();
            } else {
                Ingredients i = new Ingredients();
                this.getIngredients(i);
                ItemListGui.showItems(TheBOMPlugin.getInstance().getCategory().getBaseIngredients());
            }
            return true;
        }
        if (this.increaseOutputButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.increaseOutputButton.func_146113_a(minecraft.func_147118_V());
            TheBOMPlugin.getInstance().getCategory().increaseOutput(Keyboard.isKeyDown((int)42));
            if (ItemListGui.isGuiOpen()) {
                ItemListGui.showItems(TheBOMPlugin.getInstance().getCategory().getBaseIngredients());
            }
            this.updateDecreaseButton();
            return true;
        }
        if (this.decreaseOutputButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.decreaseOutputButton.func_146113_a(minecraft.func_147118_V());
            TheBOMPlugin.getInstance().getCategory().decreaseOutput(Keyboard.isKeyDown((int)42));
            if (ItemListGui.isGuiOpen()) {
                ItemListGui.showItems(TheBOMPlugin.getInstance().getCategory().getBaseIngredients());
            }
            this.updateDecreaseButton();
            return true;
        }
        return false;
    }

    public void updateDecreaseButton() {
        this.decreaseOutputButton.field_146124_l = TheBOMPlugin.getInstance().getCategory().getOutputAmount() > 1;
    }
}

