/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.plugin;

import com.eightbitforest.thebomplugin.TheBOMPlugin;
import com.eightbitforest.thebomplugin.plugin.BOMWrapper;
import com.eightbitforest.thebomplugin.render.BOMIngredientRenderer;
import com.eightbitforest.thebomplugin.util.BOMCalculator;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.item.ItemStack;

public class BOMCategory
implements IRecipeCategory<BOMWrapper> {
    private final IDrawable background = TheBOMPlugin.getInstance().getGuiDrawables().getCategoryBackground();
    private final IDrawable icon = TheBOMPlugin.getInstance().getGuiDrawables().getCategoryIcon();
    private final BOMIngredientRenderer ingredientRenderer = new BOMIngredientRenderer();
    private List<List<ItemStack>> baseIngredients;
    private IIngredients recipe;
    private int outputAmount = 1;
    private ItemStack output;
    private IGuiItemStackGroup guiItemStacks;

    public BOMCategory(IGuiHelper guiHelper) {
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public String getUid() {
        return TheBOMPlugin.uid;
    }

    public String getTitle() {
        return "Bill of Materials";
    }

    public String getModName() {
        return "TheBOMPlugin";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, BOMWrapper bomWrapper, IIngredients ingredients) {
        this.guiItemStacks = iRecipeLayout.getItemStacks();
        this.outputAmount = 1;
        this.recipe = ingredients;
        this.guiItemStacks.init(0, false, 72, 91);
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = x + y * 9;
                this.guiItemStacks.init(index + 1, true, (IIngredientRenderer)this.ingredientRenderer, x * 18 + 1, y * 18 + 1, 16, 16, 0, 0);
            }
        }
        this.fillGuiItemStacks();
        bomWrapper.updateDecreaseButton();
    }

    private void fillGuiItemStacks() {
        this.output = (ItemStack)((List)this.recipe.getOutputs(ItemStack.class).get(0)).get(0);
        ItemStack output = this.output.func_77946_l();
        output.func_190920_e(output.func_190916_E() * this.outputAmount);
        this.baseIngredients = BOMCalculator.getBaseIngredients(this.recipe, this.outputAmount);
        this.guiItemStacks.set(0, output);
        for (int i = 0; i < Math.min(this.baseIngredients.size(), 54); ++i) {
            this.guiItemStacks.set(i + 1, this.baseIngredients.get(i));
        }
    }

    public void increaseOutput(boolean byStack) {
        if (byStack) {
            int stackAmount = this.output.func_77976_d() / this.output.func_190916_E();
            this.outputAmount += stackAmount;
            this.outputAmount = stackAmount * Math.round((float)this.outputAmount / (float)stackAmount);
        } else {
            ++this.outputAmount;
        }
        this.fillGuiItemStacks();
    }

    public void decreaseOutput(boolean byStack) {
        if (this.outputAmount > 1) {
            if (byStack) {
                int stackAmount = this.output.func_77976_d() / this.output.func_190916_E();
                this.outputAmount -= stackAmount;
                this.outputAmount = stackAmount * Math.round((float)this.outputAmount / (float)stackAmount);
                if (this.outputAmount <= 0) {
                    this.outputAmount = 1;
                }
            } else {
                --this.outputAmount;
            }
            this.fillGuiItemStacks();
        }
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public List<List<ItemStack>> getBaseIngredients() {
        return this.baseIngredients;
    }
}

