/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.util;

import com.oitsjustjose.vtweaks.util.HelperFunctions;
import com.oitsjustjose.vtweaks.util.ModConfig;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigParser {
    private static Logger LOGGER = LogManager.getLogger((String)"vtweaks");

    public static void parseItems() {
        LOGGER.info(">> Running Config Item Parser");
        ModConfig.setChallengerLootTable(ConfigParser.parse(ModConfig.mobTweaks.challengerMobs.loot, true));
        LOGGER.info(">> Config Item Parsing complete!");
    }

    private static ArrayList<ItemStack> parse(String[] input, boolean includesQty) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (String toSplit : input) {
            String[] parts = toSplit.split("[\\W]");
            ItemStack tempStack = HelperFunctions.findItemStack(parts[0], parts[1]);
            if (tempStack.func_190926_b()) continue;
            try {
                if (parts.length == 2) {
                    ret.add(tempStack.func_77946_l());
                    continue;
                }
                if (parts.length == 3) {
                    tempStack = new ItemStack(tempStack.func_77973_b(), 1, Integer.parseInt(parts[2]));
                    ret.add(tempStack.func_77946_l());
                    continue;
                }
                if (parts.length == 4 && includesQty) {
                    tempStack = new ItemStack(tempStack.func_77973_b(), Integer.parseInt(parts[3]), Integer.parseInt(parts[2]));
                    ret.add(tempStack.func_77946_l());
                    continue;
                }
                LOGGER.info("Error parsing " + toSplit + ", please ensure proper formatting!");
            }
            catch (NumberFormatException e) {
                LOGGER.info("Error parsing " + toSplit + ", please ensure proper formatting!");
            }
        }
        return ret;
    }
}

