/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.enchantment.handler;

import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.HelperFunctions;
import com.oitsjustjose.vtweaks.util.ModConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CombatRules;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentImperishableHandler {
    @SubscribeEvent
    public void register(PlayerInteractEvent event) {
        if (!ModConfig.enchantments.enableImperishable) {
            return;
        }
        if (event.getItemStack().func_190926_b() || event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().imperishable, (ItemStack)stack) > 0 && stack.func_77952_i() >= stack.func_77958_k()) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void register(LivingHurtEvent event) {
        if (!ModConfig.enchantments.enableImperishable) {
            return;
        }
        if (event.getEntityLiving() == null || event.getSource() == null) {
            return;
        }
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b()) {
                return;
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().imperishable, (ItemStack)stack) > 0 && stack.func_77952_i() >= stack.func_77958_k()) {
                stack.func_96631_a(-1, player.func_70681_au(), null);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResult(Event.Result.DENY);
                event.setAmount(0.0f);
            }
        } else if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            float validDefense = 0.0f;
            float validToughness = 0.0f;
            for (ItemStack stack : player.func_184209_aF()) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor)) continue;
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().imperishable, (ItemStack)stack) > 0 && stack.func_77952_i() >= stack.func_77958_k()) {
                    stack.func_96631_a(-1, player.func_70681_au(), null);
                    continue;
                }
                ItemArmor armor = (ItemArmor)stack.func_77973_b();
                validDefense += (float)armor.field_77879_b;
                validToughness += armor.field_189415_e;
            }
            float damage = CombatRules.func_189427_a((float)event.getAmount(), (float)validDefense, (float)validToughness);
            event.setAmount(damage);
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (!ModConfig.enchantments.enableImperishable) {
            return;
        }
        LootCondition[] none = new LootCondition[]{};
        LootPool pool = event.getTable().getPool("main");
        if (LootTableList.field_186425_g.equals((Object)event.getName())) {
            SetNBT enchantment = new SetNBT(none, HelperFunctions.getEnchantedBookNBT(Enchantments.getInstance().imperishable, 1));
            SetCount quantity = new SetCount(none, new RandomValueRange(1.0f));
            pool.addEntry((LootEntry)new LootEntryItem(Items.field_151134_bR, 20, 0, new LootFunction[]{enchantment, quantity}, none, "vtweaks:imperishable_book"));
        }
    }
}

