/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.slime;

import com.google.common.base.Predicate;
import gigaherz.survivalist.Survivalist;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SlimeMerger {
    private static final int BIG_SLIME = 8;
    private static final int AGE_LIMIT = 200;
    private static Random rand = new Random();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new SlimeMerger());
    }

    @SubscribeEvent
    public void slimeConstruct(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EntitySlime)) {
            return;
        }
        EntitySlime slime = (EntitySlime)entity;
        slime.field_70714_bg.func_75776_a(7, (EntityAIBase)new AISlimeMerge(slime));
        slime.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAIFindOtherSlimeNearest(slime));
    }

    public static class EntityAIFindOtherSlimeNearest
    extends EntityAIFindEntityNearest {
        private static Field predicateField = ReflectionHelper.findField(EntityAIFindEntityNearest.class, (String[])new String[]{"field_179443_c", "predicate"});
        int cooldown = 5;
        private final EntitySlime slime;

        public EntityAIFindOtherSlimeNearest(EntitySlime mobIn) {
            super((EntityLiving)mobIn, EntitySlime.class);
            this.slime = mobIn;
            Predicate predicate = entity -> {
                double range = this.func_179438_f();
                return entity != null && entity != mobIn && entity.getClass() == mobIn.getClass() && entity.field_70173_aa > 200 && !entity.func_82150_aj() && (double)entity.func_70032_d((Entity)mobIn) <= range && ((EntitySlime)entity).func_70809_q() == mobIn.func_70809_q() && EntityAITarget.func_179445_a((EntityLiving)mobIn, (EntityLivingBase)entity, (boolean)false, (boolean)true);
            };
            try {
                predicateField.set((Object)this, predicate);
            }
            catch (IllegalAccessException e) {
                throw new ReportedException(new CrashReport("Could not set private field '" + predicateField.getName() + "'", (Throwable)e));
            }
        }

        public boolean func_75250_a() {
            if (this.slime.func_70809_q() >= 8) {
                return false;
            }
            if (this.slime.field_70173_aa < 200) {
                return false;
            }
            if (rand.nextFloat() > 0.05f) {
                return false;
            }
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            if (rand.nextFloat() < 0.01f) {
                return false;
            }
            return super.func_75253_b();
        }
    }

    static class AISlimeMerge
    extends EntityAIBase {
        private static Method setSlimeSizeMethod = ReflectionHelper.findMethod(EntitySlime.class, (String)"setSlimeSize", (String)"func_70799_a", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
        private final EntitySlime slime;
        private final EntityAINearestAttackableTarget.Sorter sorter;

        public AISlimeMerge(EntitySlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
            this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)slimeIn);
        }

        public boolean func_75250_a() {
            if (this.slime.func_70809_q() >= 8) {
                return false;
            }
            if (this.slime.field_70173_aa < 200) {
                return false;
            }
            if ((double)rand.nextFloat() > 0.5) {
                return false;
            }
            List list = this.slime.field_70170_p.func_175647_a(EntitySlime.class, this.slime.func_174813_aQ().func_72314_b((double)this.slime.func_70809_q() * 1.5, (double)this.slime.func_70809_q(), (double)this.slime.func_70809_q() * 1.5), other -> other != this.slime && other.func_70089_S() && other.getClass() == this.slime.getClass() && other.field_70173_aa > 200 && other.func_70809_q() == this.slime.func_70809_q());
            return list.size() >= 3;
        }

        public void func_75249_e() {
            List list = this.slime.field_70170_p.func_175647_a(EntitySlime.class, this.slime.func_174813_aQ().func_72314_b((double)this.slime.func_70809_q() * 1.5, (double)this.slime.func_70809_q(), (double)this.slime.func_70809_q() * 1.5), other -> other != this.slime && other.func_70089_S() && other.getClass() == this.slime.getClass() && other.field_70173_aa > 200 && other.func_70809_q() == this.slime.func_70809_q());
            if (list.size() >= 3) {
                int i;
                Collections.sort(list, this.sorter);
                double x = this.slime.field_70165_t;
                double y = this.slime.field_70163_u;
                double z = this.slime.field_70161_v;
                int size = this.slime.func_70809_q() + 1;
                for (i = 0; i < 8 * size; ++i) {
                    float angle = rand.nextFloat();
                    float speed = (float)size * (1.0f + rand.nextFloat() * 0.5f);
                    this.slime.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.slime.field_70165_t, this.slime.field_70163_u, this.slime.field_70161_v, (double)speed * Math.cos(angle), 1.0, (double)speed * Math.sin(angle), new int[0]);
                }
                for (i = 0; i < 3; ++i) {
                    EntitySlime target = (EntitySlime)list.get(i);
                    x += target.field_70165_t;
                    y += target.field_70163_u;
                    z += target.field_70161_v;
                    target.func_70106_y();
                    for (int j = 0; j < 8 * size; ++j) {
                        float angle = rand.nextFloat();
                        float speed = (float)size * (1.0f + rand.nextFloat() * 0.5f);
                        this.slime.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, target.field_70165_t, target.field_70163_u, target.field_70161_v, (double)speed * Math.cos(angle), 1.0, (double)speed * Math.sin(angle), new int[0]);
                    }
                }
                x /= 4.0;
                y /= 4.0;
                z /= 4.0;
                int newSize = this.slime.func_70809_q() + 1;
                try {
                    setSlimeSizeMethod.invoke((Object)this.slime, newSize, true);
                    this.slime.func_70107_b(x, y, z);
                }
                catch (ReflectiveOperationException e) {
                    throw new ReportedException(new CrashReport("Could not call method '" + setSlimeSizeMethod.getName() + "'", (Throwable)e));
                }
                this.slime.func_184185_a(Survivalist.shlop, 1.0f, 0.8f + rand.nextFloat() * 0.4f);
            }
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return false;
        }
    }
}

