/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.sawmill;

import gigaherz.survivalist.api.Choppable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TileSawmill
extends TileEntity
implements ITickable {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEMS_CAP;
    private final ItemStackHandler inventory = new ItemStackHandler(3);
    private final RangedWrapper top = new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1);
    private final RangedWrapper sides = new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 2){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!TileEntityFurnace.func_145954_b((ItemStack)stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private final RangedWrapper bottom = new RangedWrapper((IItemHandlerModifiable)this.inventory, 2, 3){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    private int remainingBurnTime;
    private int totalBurnTime;
    private int cookTime;
    private int totalCookTime;

    public boolean isBurning() {
        return this.remainingBurnTime > 0;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == ITEMS_CAP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ITEMS_CAP) {
            if (facing == EnumFacing.UP) {
                return (T)this.top;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.bottom;
            }
            if (facing != null) {
                return (T)this.sides;
            }
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ITEMS_CAP.readNBT((Object)this.inventory, null, compound.func_74781_a("Items"));
        this.remainingBurnTime = compound.func_74762_e("BurnTime");
        this.totalBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(1));
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = Choppable.getSawmillTime(this.inventory.getStackInSlot(0));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("Items", ITEMS_CAP.writeNBT((Object)this.inventory, null));
        compound.func_74768_a("BurnTime", (int)((short)this.remainingBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        return compound;
    }

    public int[] getFields() {
        return new int[]{this.remainingBurnTime, this.totalBurnTime, this.cookTime, this.totalCookTime};
    }

    public void setFields(int[] values) {
        this.remainingBurnTime = values[0];
        this.totalBurnTime = values[1];
        this.cookTime = values[2];
        this.totalCookTime = values[3];
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        boolean changes = false;
        if (this.isBurning()) {
            --this.remainingBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = this.inventory.getStackInSlot(1);
            ItemStack input = this.inventory.getStackInSlot(0);
            Choppable.ChoppingRecipe choppingRecipe = Choppable.find(input);
            if (this.isBurning() || !fuel.func_190926_b() && choppingRecipe != null) {
                if (!this.isBurning() && this.canWork(choppingRecipe)) {
                    this.remainingBurnTime = this.totalBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                    if (this.isBurning()) {
                        changes = true;
                        if (!fuel.func_190926_b()) {
                            Item item = fuel.func_77973_b();
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                ItemStack containerItem = item.getContainerItem(fuel);
                                this.inventory.setStackInSlot(1, containerItem);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canWork(choppingRecipe)) {
                    ++this.cookTime;
                    if (this.totalCookTime == 0) {
                        this.totalCookTime = choppingRecipe.getSawmillTime();
                    }
                    if (this.cookTime >= this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = choppingRecipe.getSawmillTime();
                        this.processItem();
                        changes = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
        }
        if (wasBurning != this.isBurning()) {
            changes = true;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        }
        if (changes) {
            this.func_70296_d();
        }
    }

    private boolean canWork(@Nullable Choppable.ChoppingRecipe choppingRecipe) {
        return this.getResult(choppingRecipe).func_190916_E() > 0;
    }

    private void processItem() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (input.func_190926_b()) {
            return;
        }
        Choppable.ChoppingRecipe choppingRecipe = Choppable.find(input);
        if (choppingRecipe == null) {
            return;
        }
        ItemStack result = this.getResult(choppingRecipe);
        if (result.func_190916_E() <= 0) {
            return;
        }
        this.inventory.insertItem(2, result, false);
        input.func_190918_g(1);
    }

    private ItemStack getResult(@Nullable Choppable.ChoppingRecipe choppingRecipe) {
        if (choppingRecipe == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = choppingRecipe.getResultsSawmill();
        ItemStack output = this.inventory.getStackInSlot(2);
        int max = Math.min(this.inventory.getSlotLimit(2), output.func_77976_d());
        int space = max - output.func_190916_E();
        if (space < result.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        return result;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getTotalCookTime() {
        return this.totalCookTime;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }
}

