/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration.chopping;

import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.client.StackRenderingHelper;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ChoppingRecipeWrapper
implements IRecipeWrapper {
    private double multiplier;
    private ItemStack output;

    public static IRecipeWrapper wrap(Choppable.ChoppingRecipe pair) {
        if (pair instanceof Choppable.ChoppingItemRecipe) {
            return new ItemInput((Choppable.ChoppingItemRecipe)pair);
        }
        if (pair instanceof Choppable.ChoppingOreRecipe) {
            return new OreInput((Choppable.ChoppingOreRecipe)pair);
        }
        throw new RuntimeException("Can not import recipe");
    }

    private static ItemStack copyWithSize(ItemStack middle) {
        middle = middle.func_77946_l();
        middle.func_190920_e(1);
        return middle;
    }

    private ChoppingRecipeWrapper(ItemStack output, double multiplier) {
        this.output = output;
        this.multiplier = multiplier;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void drawInfo(@Nonnull Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        ItemModelMesher mesher = mc.func_175599_af().func_175037_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        long animTick = mc.field_71441_e.func_82737_E();
        int whichAxe = (int)(animTick / 20L % 5L);
        double amount = 1.0;
        ItemStack stack = null;
        switch (whichAxe) {
            case 0: {
                amount = 0.4 * this.multiplier;
                stack = null;
                break;
            }
            case 1: {
                amount = ConfigManager.instance.getAxeLevelMultiplier(1) * this.multiplier;
                stack = new ItemStack(Items.field_151053_p);
                break;
            }
            case 2: {
                amount = ConfigManager.instance.getAxeLevelMultiplier(2) * this.multiplier;
                stack = new ItemStack(Items.field_151049_t);
                break;
            }
            case 3: {
                amount = ConfigManager.instance.getAxeLevelMultiplier(3) * this.multiplier;
                stack = new ItemStack(Items.field_151036_c);
                break;
            }
            case 4: {
                amount = ConfigManager.instance.getAxeLevelMultiplier(4) * this.multiplier;
                stack = new ItemStack(Items.field_151056_x);
            }
        }
        if (stack != null) {
            StackRenderingHelper.renderItemStack(mesher, mc.field_71446_o, 28, 4, stack, -1);
        }
        String label = amount + "x";
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)150.0f);
        mc.field_71466_p.func_175065_a(label, (float)(58 - mc.field_71466_p.func_78256_a(label)), 14.0f, -1, true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private static class OreInput
    extends ChoppingRecipeWrapper {
        private String inputOredict;

        private OreInput(String input, ItemStack output, double multiplier) {
            super(output, multiplier);
            this.inputOredict = input;
        }

        public OreInput(Choppable.ChoppingOreRecipe recipe) {
            this(recipe.getOreName(), ChoppingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getOutputMultiplier());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, Collections.singletonList(OreDictionary.getOres((String)this.inputOredict)));
            super.getIngredients(ingredients);
        }
    }

    private static class ItemInput
    extends ChoppingRecipeWrapper {
        private ItemStack inputStack;

        private ItemInput(ItemStack input, ItemStack output, double multiplier) {
            super(output, multiplier);
            this.inputStack = input;
        }

        public ItemInput(Choppable.ChoppingItemRecipe recipe) {
            this(recipe.getInput(), ChoppingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getOutputMultiplier());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.inputStack);
            super.getIngredients(ingredients);
        }
    }
}

