/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.externaltweaker.app.panels;

import com.bartz24.externaltweaker.app.Strings;
import com.bartz24.externaltweaker.app.panels.PanelData;
import com.bartz24.externaltweaker.app.panels.PanelParameterEdit;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelStackParam
extends PanelData {
    private JButton btnCurSel;
    private JCheckBox chkMeta;
    public JTextField stackEdit = new JTextField();
    private JSpinner spinnerCount;

    public PanelStackParam(PanelParameterEdit parent) {
        super(parent);
        this.btnCurSel = new JButton("Use Current Selection");
        JPanel countPanel = new JPanel();
        FlowLayout fl_countPanel = (FlowLayout)countPanel.getLayout();
        JLabel lblCount = new JLabel("Count");
        countPanel.add(lblCount);
        this.spinnerCount = new JSpinner();
        this.spinnerCount.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.spinnerCount.setPreferredSize(new Dimension(60, 20));
        countPanel.add(this.spinnerCount);
        this.chkMeta = new JCheckBox("Any Metadata/Damage");
        this.chkMeta.setEnabled(!this.parentPanel.getSubtype().equals("ILiquidStack"));
        this.chkMeta.setHorizontalAlignment(0);
        JButton btnAdvOption = new JButton("Open Advanced Options (WIP)");
        btnAdvOption.setEnabled(false);
        GroupLayout groupLayout_2 = new GroupLayout(this);
        groupLayout_2.setHorizontalGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout_2.createSequentialGroup().addContainerGap().addGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout_2.createSequentialGroup().addComponent(this.btnCurSel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stackEdit, -1, 283, Short.MAX_VALUE)).addGroup(groupLayout_2.createSequentialGroup().addGap(5).addComponent(countPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkMeta).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnAdvOption, -2, 184, Short.MAX_VALUE))).addContainerGap()));
        groupLayout_2.setVerticalGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout_2.createSequentialGroup().addGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCurSel).addComponent(this.stackEdit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkMeta).addComponent(btnAdvOption)).addComponent(countPanel, -2, -1, -2)).addContainerGap(84, Short.MAX_VALUE)));
        this.setLayout(groupLayout_2);
    }

    @Override
    public void update() {
        this.updateCurSelBtn(this.parentPanel.mainFrame.table.getSelectedRow() >= 0 && this.parentPanel.mainFrame.table.getSelectedColumn() >= 0 ? this.parentPanel.mainFrame.table.getValueAt(this.parentPanel.mainFrame.table.getSelectedRow(), 0).toString() : "");
    }

    public void updateCurSelBtn(String curSel) {
        String s = curSel.replace("<", "").replace(">", "");
        boolean enabled = true;
        if (this.parentPanel.getSubtype().equals("IItemStack") && (s.startsWith("ore") || s.startsWith("liquid"))) {
            enabled = false;
        } else if (this.parentPanel.getSubtype().equals("IIngredient") && s.startsWith("liquid")) {
            enabled = false;
        } else if (this.parentPanel.getSubtype().equals("ILiquidStack") && !s.startsWith("liquid")) {
            enabled = false;
        } else if (Strings.isNullOrEmpty(s)) {
            enabled = false;
        }
        this.btnCurSel.setEnabled(enabled);
    }

    @Override
    public String exportData() {
        if (!Strings.isNullOrEmpty(this.stackEdit.getText())) {
            try {
                String base = this.stackEdit.getText();
                String[] stackData = base.substring(base.indexOf("<"), base.indexOf(">") + 1).replace("<", "").replace(">", "").split(":");
                if (this.parentPanel.getSubtype().equals("IItemStack") && this.chkMeta.isSelected()) {
                    if (stackData.length < 3) {
                        String[] newData = new String[3];
                        System.arraycopy(stackData, 0, newData, 0, stackData.length);
                        stackData = newData;
                    }
                    stackData[2] = "*";
                }
                String stackNew = "<" + stackData[0] + ":" + stackData[1] + (stackData.length > 2 ? ":" + stackData[2] : "") + ">";
                base = stackNew + base.substring(base.indexOf(">") + 1) + ((Integer)this.spinnerCount.getValue() > 1 ? " * " + this.spinnerCount.getValue() : "");
                return base;
            }
            catch (Exception e) {
                return "null";
            }
        }
        return "null";
    }

    @Override
    public void importData(String input) {
        if (Strings.isNullOrEmpty(input) || input.equals("null")) {
            this.stackEdit.setText("null");
        }
        if (!Strings.isNullOrEmpty(input)) {
            this.parentPanel.importing = true;
            try {
                String[] stackData;
                input = input.trim();
                String outside = input.substring(input.indexOf(">") + 1);
                if (outside.contains("*")) {
                    this.spinnerCount.setValue(Integer.parseInt(outside.substring(outside.indexOf("*") + 1).replace(" ", "")));
                }
                if ((stackData = input.substring(input.indexOf("<"), input.indexOf(">") + 1).replace("<", "").replace(">", "").split(":")).length > 2) {
                    this.chkMeta.setSelected(stackData[2].equals("*"));
                }
                String text = "";
                for (int i = 0; i < stackData.length; ++i) {
                    text = text + stackData[i];
                    if (i >= stackData.length - 1) continue;
                    text = text + ":";
                }
                if (outside.contains("*")) {
                    outside = outside.substring(0, outside.indexOf("*") - 1).trim();
                }
                text = "<" + text + ">" + outside;
                this.stackEdit.setText(text);
            }
            catch (Exception e) {
                this.stackEdit.setText(input);
            }
            this.parentPanel.importing = false;
        }
    }

    @Override
    public void setListeners() {
        this.stackEdit.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!PanelStackParam.this.parentPanel.importing) {
                    PanelStackParam.this.parentPanel.mainFrame.updateParameters();
                    PanelStackParam.this.parentPanel.mainFrame.updateRecipesList(true);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.btnCurSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PanelStackParam.this.parentPanel.importing && PanelStackParam.this.parentPanel.mainFrame.table.getSelectedRow() >= 0 && PanelStackParam.this.parentPanel.mainFrame.table.getSelectedColumn() >= 0) {
                    PanelStackParam.this.stackEdit.setText(PanelStackParam.this.parentPanel.mainFrame.table.getValueAt(PanelStackParam.this.parentPanel.mainFrame.table.getSelectedRow(), 0).toString());
                    PanelStackParam.this.parentPanel.mainFrame.updateParameters();
                    PanelStackParam.this.parentPanel.mainFrame.updateRecipesList(true);
                }
            }
        });
        this.spinnerCount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!PanelStackParam.this.parentPanel.importing) {
                    PanelStackParam.this.parentPanel.mainFrame.updateParameters();
                    PanelStackParam.this.parentPanel.mainFrame.updateRecipesList(true);
                }
            }
        });
        this.chkMeta.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!(Strings.isNullOrEmpty(PanelStackParam.this.stackEdit.getText()) || PanelStackParam.this.stackEdit.getText().startsWith("<ore:") || PanelStackParam.this.parentPanel.importing)) {
                    PanelStackParam.this.parentPanel.mainFrame.updateParameters();
                    PanelStackParam.this.parentPanel.mainFrame.updateRecipesList(true);
                }
            }
        });
    }
}

