/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.externaltweaker.app.panels;

import com.bartz24.externaltweaker.app.AppFrame;
import com.bartz24.externaltweaker.app.JPlaceholderTextField;
import com.bartz24.externaltweaker.app.Strings;
import com.bartz24.externaltweaker.app.panels.PanelArrayParam;
import com.bartz24.externaltweaker.app.panels.PanelBooleanParam;
import com.bartz24.externaltweaker.app.panels.PanelData;
import com.bartz24.externaltweaker.app.panels.PanelNumParam;
import com.bartz24.externaltweaker.app.panels.PanelStackParam;
import com.bartz24.externaltweaker.app.panels.PanelStringParam;
import com.bartz24.externaltweaker.app.panels.PanelUnsupportedParam;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public class PanelParameterEdit
extends JPanel {
    public int paramNum;
    public String paramType;
    public PanelData editPanel;
    public JPlaceholderTextField txtName;
    public AppFrame mainFrame;
    protected boolean importing;
    private JButton btnCopy;
    public JButton btnPaste;
    private JCheckBox chkOptional;

    public PanelParameterEdit(int parameterNum, String parameterType, AppFrame mainframe) {
        this.paramNum = parameterNum;
        this.paramType = parameterType;
        this.mainFrame = mainframe;
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPanelHeight()));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPanelHeight()));
        this.setBorder(new BevelBorder(0, null, null, null, null));
        JLabel lblParamType = new JLabel(this.paramType.replace("optional.", "(Optional) "));
        lblParamType.setHorizontalAlignment(2);
        this.editPanel = this.getNewPanelData();
        this.txtName = new JPlaceholderTextField("Parameter " + this.paramNum);
        this.txtName.setDisabledTextColor(UIManager.getColor("Button.disabledText"));
        this.txtName.setColumns(10);
        JPanel panel = new JPanel();
        this.btnCopy = new JButton("Copy");
        this.btnPaste = new JButton("Paste");
        this.btnPaste.setEnabled(this.paramType.equals(this.mainFrame.copyType));
        this.chkOptional = new JCheckBox("");
        this.chkOptional.setToolTipText("(Optional Only) Allow");
        this.chkOptional.setEnabled(this.isOptional());
        this.chkOptional.setSelected(!this.isOptional());
        GroupLayout gl_panel = new GroupLayout(this);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editPanel, -1, 421, Short.MAX_VALUE).addGroup(gl_panel.createSequentialGroup().addComponent(this.txtName, -1, 38, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkOptional).addGap(10).addComponent(lblParamType, -1, 62, Short.MAX_VALUE).addGap(5).addComponent(panel, -2, 126, -2).addGap(8).addComponent(this.btnCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPaste, -2, 81, -2))).addContainerGap()));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(14).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gl_panel.createSequentialGroup().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(panel, -2, 24, -2).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPaste).addComponent(this.btnCopy))).addGap(7)).addGroup(GroupLayout.Alignment.TRAILING, gl_panel.createSequentialGroup().addComponent(lblParamType).addGap(12)).addGroup(GroupLayout.Alignment.TRAILING, gl_panel.createSequentialGroup().addComponent(this.chkOptional).addGap(9)))).addGroup(gl_panel.createSequentialGroup().addGap(17).addComponent(this.txtName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.editPanel, -1, 151, Short.MAX_VALUE).addContainerGap()));
        panel.setLayout(new FlowLayout(1, 0, 0));
        this.setLayout(gl_panel);
    }

    public PanelData getNewPanelData(String type) {
        if (type.equals("int") || type.equals("double") || type.equals("float")) {
            return new PanelNumParam(this);
        }
        if (type.equals("IItemStack") || type.equals("ILiquidStack") || type.equals("IIngredient")) {
            return new PanelStackParam(this);
        }
        if (type.equals("String")) {
            return new PanelStringParam(this);
        }
        if (type.equals("boolean")) {
            return new PanelBooleanParam(this);
        }
        if (type.endsWith("[]")) {
            return new PanelArrayParam(this);
        }
        return new PanelUnsupportedParam(this);
    }

    public PanelData getNewPanelData() {
        return this.getNewPanelData(this.getSubtype());
    }

    public int getPanelHeight() {
        if (this.getSubtype().equals("int") || this.getSubtype().equals("double") || this.getSubtype().equals("float")) {
            return 100;
        }
        if (this.getSubtype().equals("IItemStack") || this.getSubtype().equals("ILiquidStack") || this.getSubtype().equals("IIngredient")) {
            return 150;
        }
        if (this.getSubtype().equals("String")) {
            return 100;
        }
        if (this.getSubtype().equals("boolean")) {
            return 100;
        }
        if (this.getSubtype().endsWith("[]")) {
            return 500;
        }
        return 100;
    }

    public String getSubtype() {
        return this.isOptional() ? this.paramType.substring("optional.".length()) : this.paramType;
    }

    public boolean isOptional() {
        return this.paramType.startsWith("optional.");
    }

    public String getParameterName() {
        return this.txtName.getText();
    }

    public String exportData() {
        if (this.isOptional() && !this.chkOptional.isSelected()) {
            return "~";
        }
        return this.editPanel.exportData();
    }

    public void importData(String input) {
        if (!(Strings.isNullOrEmpty(input) || this.isOptional() && input.equals("~"))) {
            this.editPanel.importData(input);
        }
        if (!Strings.isNullOrEmpty(input) && this.isOptional()) {
            this.chkOptional.setSelected(!input.equals("~"));
        }
    }

    public void setListeners() {
        this.txtName.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                int comboIndex = PanelParameterEdit.this.mainFrame.comboRecipes.getSelectedIndex();
                int index = PanelParameterEdit.this.mainFrame.indexOfRecipeFormat(PanelParameterEdit.this.mainFrame.getCurrentScript().recipes.get(comboIndex).getRecipeFormat());
                if (index >= 0) {
                    PanelParameterEdit.this.mainFrame.recipeData.get(index).setParamName(PanelParameterEdit.this.paramNum - 1, PanelParameterEdit.this.txtName.getText());
                    ((DefaultListModel)PanelParameterEdit.this.mainFrame.listMethods.getModel()).setElementAt(PanelParameterEdit.this.mainFrame.recipeData.get(index).getRecipeDisplay(), index);
                    PanelParameterEdit.this.mainFrame.updateRecipesList(true);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.chkOptional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PanelParameterEdit.this.importing) {
                    int comboIndex = PanelParameterEdit.this.mainFrame.comboRecipes.getSelectedIndex();
                    PanelParameterEdit.this.mainFrame.getCurrentScript().recipes.get(comboIndex).setParameterData(PanelParameterEdit.this.paramNum - 1, !PanelParameterEdit.this.chkOptional.isSelected() ? "~" : PanelParameterEdit.this.exportData());
                    PanelParameterEdit.this.mainFrame.updateRecipesList(true);
                }
            }
        });
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelParameterEdit.this.mainFrame.copyData = PanelParameterEdit.this.exportData();
                PanelParameterEdit.this.mainFrame.copyType = PanelParameterEdit.this.paramType;
                PanelParameterEdit.this.mainFrame.lblCopying.setText("Currently Copying: " + PanelParameterEdit.this.mainFrame.copyData + " [" + PanelParameterEdit.this.mainFrame.copyType + "]");
                PanelParameterEdit.this.mainFrame.updateParameters();
            }
        });
        this.btnPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelParameterEdit.this.importData(PanelParameterEdit.this.mainFrame.copyData);
                if (!PanelParameterEdit.this.importing) {
                    PanelParameterEdit.this.mainFrame.updateParameters();
                    PanelParameterEdit.this.mainFrame.updateRecipesList(true);
                }
            }
        });
        this.editPanel.setListeners();
    }
}

