/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.externaltweaker.app.panels;

import com.bartz24.externaltweaker.app.Strings;
import com.bartz24.externaltweaker.app.panels.PanelData;
import com.bartz24.externaltweaker.app.panels.PanelParameterEdit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelArrayParam
extends PanelData {
    private String[][] data;
    private JPanel backPanel;
    private JSpinner spinnerRow;
    private JSpinner spinnerSizeX;
    private JSpinner spinnerSizeY;
    public List<PanelData> paramPanels = new ArrayList<PanelData>();
    private static boolean changingSize;

    public PanelArrayParam(PanelParameterEdit parent) {
        super(parent);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        this.backPanel = new JPanel();
        this.backPanel.setBorder(new BevelBorder(0, null, null, null, null));
        scrollPane.setViewportView(this.backPanel);
        this.backPanel.setLayout(new BoxLayout(this.backPanel, 1));
        this.spinnerSizeX = new JSpinner();
        this.spinnerSizeX.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.spinnerSizeY = new JSpinner();
        this.spinnerSizeY.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        JLabel lblNewLabel = new JLabel("x");
        JLabel lblNewLabel_1 = new JLabel("Grid Size");
        this.spinnerRow = new JSpinner();
        this.spinnerRow.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        JLabel lblNewLabel_2 = new JLabel("Current Row");
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(scrollPane, -1, 607, Short.MAX_VALUE).addGap(0)).addGroup(groupLayout.createSequentialGroup().addContainerGap(287, Short.MAX_VALUE).addComponent(lblNewLabel_2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRow, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lblNewLabel_1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerSizeX, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblNewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerSizeY, -2, 56, -2).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerSizeX, -2, -1, -2).addComponent(this.spinnerSizeY, -2, -1, -2).addComponent(lblNewLabel).addComponent(lblNewLabel_1).addComponent(this.spinnerRow, -2, -1, -2).addComponent(lblNewLabel_2)).addGap(5).addComponent(scrollPane, -1, 473, Short.MAX_VALUE).addContainerGap()));
        this.setLayout(groupLayout);
        this.spinnerRow.setEnabled(this.isDoubleArray());
        this.spinnerSizeY.setEnabled(this.isDoubleArray());
        this.data = new String[1][1];
        this.updateCurrentRow();
    }

    private boolean isDoubleArray() {
        String bracketsOnly = this.parentPanel.getSubtype().substring(this.parentPanel.getSubtype().indexOf("["), this.parentPanel.getSubtype().length());
        return bracketsOnly.length() / 2 == 2;
    }

    @Override
    public String exportData() {
        if (this.data == null) {
            return "";
        }
        if (this.isDoubleArray()) {
            String returning = "[";
            for (int i = 0; i < (Integer)this.spinnerSizeY.getValue(); ++i) {
                returning = returning + Arrays.toString(this.data[i]);
                if (i >= (Integer)this.spinnerSizeY.getValue() - 1) continue;
                returning = returning + ", ";
            }
            return returning + "]";
        }
        return Arrays.toString(this.data[0]);
    }

    @Override
    public void importData(String input) {
        if (Strings.isNullOrEmpty(input)) {
            return;
        }
        this.parentPanel.importing = true;
        if (!this.isDoubleArray()) {
            String[] addData = this.getSingleArray(input);
            this.data = new String[1][addData.length];
            this.data[0] = addData;
        } else {
            this.data = this.getDoubleArray(input);
        }
        if (this.data.length == 0 || this.data[0].length == 0) {
            this.data = new String[1][1];
        }
        this.spinnerSizeX.setValue(this.data[0].length);
        this.spinnerSizeY.setValue(this.data.length);
        ((SpinnerNumberModel)this.spinnerRow.getModel()).setMaximum((Integer)this.spinnerSizeY.getValue());
        this.updateCurrentRow();
        this.parentPanel.importing = false;
    }

    private String[] getSingleArray(String data) {
        String newData = data.substring(1, data.length() - 1);
        HashMap<Integer, String> arrayIndexes = new HashMap<Integer, String>();
        boolean changedSomething = true;
        while (changedSomething) {
            String arg;
            changedSomething = false;
            while (newData.contains(".withTag(") && newData.contains(")") && newData.indexOf(".withTag(") < newData.indexOf(")") && !newData.substring(newData.indexOf(".withTag("), newData.indexOf(")") + 1).contains(".onlyWithTag(")) {
                arg = newData.substring(newData.indexOf(".withTag("), newData.indexOf(")") + 1);
                newData = newData.replace(arg, "~" + arrayIndexes.size() + "~");
                arrayIndexes.put(arrayIndexes.size(), arg);
                changedSomething = true;
            }
            if (!changedSomething) {
                while (newData.contains(".onlyWithTag(") && newData.contains(")") && newData.indexOf(".onlyWithTag(") < newData.indexOf(")")) {
                    arg = newData.substring(newData.indexOf(".onlyWithTag("), newData.indexOf(")") + 1);
                    newData = newData.replace(arg, "~" + arrayIndexes.size() + "~");
                    arrayIndexes.put(arrayIndexes.size(), arg);
                    changedSomething = true;
                }
            }
            if (!changedSomething) {
                while (newData.contains("[[") && newData.contains("]]") && newData.indexOf("[[") < newData.indexOf("]]")) {
                    arg = newData.substring(newData.indexOf("[["), newData.indexOf("]]") + 2);
                    newData = newData.replace(arg, "~" + arrayIndexes.size() + "~");
                    arrayIndexes.put(arrayIndexes.size(), arg);
                    changedSomething = true;
                }
            }
            if (changedSomething) continue;
            while (newData.contains("[") && newData.contains("]") && newData.indexOf("[") < newData.indexOf("]")) {
                arg = newData.substring(newData.indexOf("["), newData.indexOf("]") + 1);
                newData = newData.replace(arg, "~" + arrayIndexes.size() + "~");
                arrayIndexes.put(arrayIndexes.size(), arg);
                changedSomething = true;
            }
        }
        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(newData.split(",")));
        for (int i = 0; i < paramList.size(); ++i) {
            paramList.set(i, ((String)paramList.get(i)).trim());
            boolean changed = true;
            String p = ((String)paramList.get(i)).substring(0, ((String)paramList.get(i)).length());
            while (changed) {
                changed = false;
                for (int i2 = 0; i2 < arrayIndexes.size(); ++i2) {
                    if (!p.contains("~" + i2 + "~")) continue;
                    p = p.replace("~" + i2 + "~", (CharSequence)arrayIndexes.get(i2));
                    changed = true;
                }
            }
            paramList.set(i, p);
        }
        return paramList.toArray(new String[paramList.size()]);
    }

    private String[][] getDoubleArray(String data) {
        String newData = data.substring(1, data.length() - 1);
        String[] array = newData.split(Pattern.quote("], ["));
        ArrayList<String[]> listArrays = new ArrayList<String[]>();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                array[i] = "[" + array[i];
            }
            if (i < array.length - 1) {
                int n = i;
                array[n] = array[n] + "]";
            }
            listArrays.add(this.getSingleArray(array[i]));
        }
        return (String[][])listArrays.toArray((T[])new String[listArrays.size()][((String[])listArrays.get(0)).length]);
    }

    @Override
    public void update() {
        for (int i = 0; i < this.paramPanels.size(); ++i) {
            this.paramPanels.get(i).update();
            this.data[((Integer)this.spinnerRow.getValue()).intValue() - 1][i] = this.paramPanels.get(i).exportData();
        }
        this.spinnerSizeX.setValue(this.data[0].length);
        this.spinnerSizeY.setValue(this.data.length);
        ((SpinnerNumberModel)this.spinnerRow.getModel()).setMaximum((Integer)this.spinnerSizeY.getValue());
    }

    private void updateCurrentRow() {
        this.backPanel.removeAll();
        this.paramPanels.clear();
        if (this.data != null && (Integer)this.spinnerRow.getValue() - 1 >= 0) {
            int i;
            for (i = 0; i < (Integer)this.spinnerSizeX.getValue(); ++i) {
                this.addParameter(this.parentPanel.getSubtype().substring(0, this.parentPanel.getSubtype().indexOf("[")), i);
            }
            for (i = 0; i < this.paramPanels.size(); ++i) {
                this.paramPanels.get(i).importData(this.data[(Integer)this.spinnerRow.getValue() - 1][i]);
            }
            this.update();
        }
        this.backPanel.revalidate();
        this.backPanel.repaint();
    }

    private void addParameter(String type, int index) {
        String subtype = (type = type.trim()).startsWith("optional.") ? type.substring("optional.".length()) : type;
        PanelData p = this.parentPanel.getNewPanelData(subtype);
        p.setBorder(new BevelBorder(0, null, null, null, null));
        p.setToolTipText("Located at " + (index + 1) + ", " + this.spinnerRow.getValue().toString());
        p.setListeners();
        this.backPanel.add(p);
        this.paramPanels.add(p);
    }

    @Override
    public void setListeners() {
        this.spinnerRow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!PanelArrayParam.this.parentPanel.importing) {
                    PanelArrayParam.this.updateCurrentRow();
                }
            }
        });
        this.spinnerSizeX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!PanelArrayParam.this.parentPanel.importing && !changingSize) {
                    changingSize = true;
                    String[][] newData = new String[((Integer)PanelArrayParam.this.spinnerSizeY.getValue()).intValue()][((Integer)PanelArrayParam.this.spinnerSizeX.getValue()).intValue()];
                    for (int y = 0; y < PanelArrayParam.this.data.length; ++y) {
                        for (int x = 0; x < PanelArrayParam.this.data[0].length; ++x) {
                            if (y >= newData.length || x >= newData[0].length) continue;
                            newData[y][x] = PanelArrayParam.this.data[y][x];
                        }
                    }
                    PanelArrayParam.access$402(PanelArrayParam.this, newData);
                    PanelArrayParam.this.updateCurrentRow();
                    PanelArrayParam.this.parentPanel.mainFrame.updateParameters();
                    PanelArrayParam.this.parentPanel.mainFrame.updateRecipesList(true);
                    changingSize = false;
                }
            }
        });
        this.spinnerSizeY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!PanelArrayParam.this.parentPanel.importing && !changingSize) {
                    changingSize = true;
                    String[][] newData = new String[((Integer)PanelArrayParam.this.spinnerSizeY.getValue()).intValue()][((Integer)PanelArrayParam.this.spinnerSizeX.getValue()).intValue()];
                    for (int y = 0; y < PanelArrayParam.this.data.length; ++y) {
                        for (int x = 0; x < PanelArrayParam.this.data[0].length; ++x) {
                            if (y >= newData.length || x >= newData[0].length) continue;
                            newData[y][x] = PanelArrayParam.this.data[y][x];
                        }
                    }
                    PanelArrayParam.access$402(PanelArrayParam.this, newData);
                    if ((Integer)PanelArrayParam.this.spinnerRow.getValue() > (Integer)PanelArrayParam.this.spinnerSizeY.getValue()) {
                        PanelArrayParam.this.spinnerRow.setValue(PanelArrayParam.this.spinnerSizeY.getValue());
                    }
                    PanelArrayParam.this.updateCurrentRow();
                    PanelArrayParam.this.parentPanel.mainFrame.updateParameters();
                    PanelArrayParam.this.parentPanel.mainFrame.updateRecipesList(true);
                    changingSize = false;
                }
            }
        });
    }

    static /* synthetic */ String[][] access$402(PanelArrayParam x0, String[][] x1) {
        x0.data = x1;
        return x1;
    }
}

