/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.externaltweaker.app.data;

import com.bartz24.externaltweaker.app.Strings;
import java.io.Serializable;
import java.util.List;

public class ETRecipeData
implements Serializable {
    private String recipeFormat;
    private String[] paramNames;
    private boolean addRecipe;

    public ETRecipeData(String recipe, String[] parameterNames, boolean isAdd) {
        this.recipeFormat = recipe;
        this.paramNames = parameterNames.length == 0 ? new String[this.getParameterCount()] : parameterNames;
        this.addRecipe = isAdd;
    }

    public ETRecipeData(String recipe, List<String> parameterNames, boolean isAdd) {
        this.recipeFormat = recipe;
        this.paramNames = parameterNames.size() == 0 ? new String[this.getParameterCount()] : parameterNames.toArray(new String[this.getParameterCount()]);
        this.addRecipe = isAdd;
    }

    public int getParameterCount() {
        return this.getParameterTypes().length;
    }

    public int getParameterCountOptMin() {
        int num = this.getParameterCount();
        for (String s : this.getParameterTypes()) {
            if (!s.startsWith("optional.")) continue;
            --num;
        }
        return num;
    }

    public String[] getParameterTypes() {
        return this.recipeFormat.substring(this.recipeFormat.indexOf("(") + 1, this.recipeFormat.length() - 2).split(", ");
    }

    public String getRecipeDisplay() {
        String s = this.recipeFormat.substring(0, this.recipeFormat.indexOf("(") + 1);
        for (int i = 0; i < this.getParameterCount(); ++i) {
            s = i >= this.paramNames.length || Strings.isNullOrEmpty(this.paramNames[i]) ? s + this.getParameterTypes()[i].trim() : s + this.paramNames[i].trim();
            s = s + ", ";
        }
        return s.substring(0, s.length() - 2) + ");";
    }

    public String getRecipeFormat() {
        return this.recipeFormat;
    }

    public void setParamName(int index, String name) {
        this.paramNames[index] = name;
    }

    public String getParamName(int index) {
        return this.paramNames[index];
    }

    public boolean isAddRecipe() {
        return this.addRecipe;
    }

    public void setAddRecipe(boolean isAddRecipe) {
        this.addRecipe = isAddRecipe;
    }
}

