/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.tonics.CompositeTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class TonicToTippedArrowsRecipe
extends ShapedOreRecipe {
    TonicToTippedArrowsRecipe(ShapedOreRecipe template) {
        super(null, template.func_77571_b(), MinecraftGlue.JR.primerFrom(template));
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        List<PotionEffect> effects;
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        ItemStack tipped_arrow = new ItemStack(MinecraftGlue.Items_tipped_arrow);
        if (tipped_arrow.func_190926_b()) {
            return out;
        }
        ItemStack tonic = null;
        int n_spread = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next)) continue;
            if (MinecraftGlue.RID.matches(next, "arrow", MinecraftGlue.Items_arrow)) {
                ++n_spread;
                continue;
            }
            if (!TonicDrink.isa(next)) continue;
            tonic = next;
        }
        if (tonic != null && n_spread > 0 && !(effects = MinecraftGlue.Potions.getEffects(tonic, false)).isEmpty() && !(effects = CompositeTonicRecipe.splitEffects(effects, n_spread)).isEmpty()) {
            out = tipped_arrow;
            MinecraftGlue.Potions.copyDefinition(tonic, out);
            this.initUnlocalizedName(tonic, out);
            if (tonic.func_82837_s()) {
                out.func_151001_c(tonic.func_82833_r());
            }
            out.func_190920_e(n_spread);
        }
        return out;
    }

    private void initUnlocalizedName(ItemStack tonic, ItemStack arrow) {
        PotionType type = PotionUtils.func_185191_c((ItemStack)tonic);
        if (!MinecraftGlue.Potions.isReal(type)) {
            MinecraftGlue.ItemStacks_setStackUnlocalizedName(arrow, "tipped_arrow.effect.moonshine_potion");
        }
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapedOreRecipe impl = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            return new TonicToTippedArrowsRecipe(impl);
        }
    }
}

