/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class BasicTonicRecipe
extends ShapedOreRecipe {
    BasicTonicRecipe(ShapedOreRecipe template) {
        super(null, template.func_77571_b(), MinecraftGlue.JR.primerFrom(template));
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        if (!VfpConfig.getInstance().allowMoonshineMixing()) {
            return out;
        }
        ItemStack potion = null;
        int n_spread = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next)) continue;
            if (MinecraftGlue.RID.matches(next, "itemEmptyBottle", VfpObj.Our_Empty_Bottle_obj)) {
                ++n_spread;
                continue;
            }
            if (!MinecraftGlue.Potions.isa(next, false)) continue;
            if (potion != null) {
                return out;
            }
            potion = next;
        }
        if (n_spread == 1 && potion != null) {
            out = TonicDrink.create(potion, n_spread);
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return BasicTonicRecipe.getRemainingIncludingEmptyGlassBottles(grid);
    }

    static final NonNullList<ItemStack> getRemainingIncludingEmptyGlassBottles(InventoryCrafting grid) {
        NonNullList out = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)grid);
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            if (!((ItemStack)out.get(i)).func_190926_b() || !MinecraftGlue.Potions.isap(grid.func_70301_a(i), false)) continue;
            out.set(i, (Object)new ItemStack(MinecraftGlue.Items_empty_bottle));
        }
        return out;
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapedOreRecipe impl = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            return new BasicTonicRecipe(impl);
        }
    }
}

