/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableFood;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.tonics.SoakFoodShapedRecipe;

public final class RoastedSeeds
extends VfpSoakableFood {
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Roasted_Seeds, RoastedSeeds.class, "type");
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, VfpOid.Roasted_Seeds.fmlid() + "_pumpkin", LikeFood.seed, VARIANT_SET, true), new VfpVariant(1, VfpOid.Roasted_Seeds.fmlid() + "_sunflower", LikeFood.seed, VARIANT_SET, false)};
    private static RoastedSeeds INSTANCE;

    public RoastedSeeds(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_ARRAY, tab);
    }

    static final RoastedSeeds makeObjects(VfpConfig config) {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Roasted_Seeds, RoastedSeeds.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            ItemStack sunflower_seeds = RoastedSeeds.sunflower(1);
            OreDictionary.registerOre((String)"ingredientSunflowerSeeds", (ItemStack)sunflower_seeds);
            OreDictionary.registerOre((String)"ingredientCondiment", (ItemStack)sunflower_seeds);
        }
    }

    static final void buildRecipes(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (!config.isPresent("roast_seeds")) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(MinecraftGlue.Items_pumpkin_seeds), (ItemStack)new ItemStack((Item)INSTANCE, 1, 0), (float)LikeFood.seed.smeltExperience());
        }
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 8, 0), new Object[]{"xxx", "xhx", "xxx", Character.valueOf('x'), MinecraftGlue.Items_pumpkin_seeds, Character.valueOf('h'), "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[0].fmlid())), LikeFood.seed.craftExperience() * 8.0f));
        if (config.allowMoonshineMixing()) {
            recipes.register(new SoakFoodShapedRecipe(new ItemStack((Item)INSTANCE, 8, 0), "xxx", "xPx", "xxx", Character.valueOf('x'), new ItemStack((Item)INSTANCE, 1, 0), Character.valueOf('P'), "itemPotionBottle").setRegistryName(ModInfo.r("soaked_" + VARIANT_ARRAY[0].fmlid())));
        }
        if (!config.isPresent("roast_seeds")) {
            GameRegistry.addSmelting((ItemStack)VfpObj.Sunflower_plant_obj.func_77946_l(), (ItemStack)new ItemStack((Item)INSTANCE, VfpCapacity.DENSE_CRYSTAL_BATCH.count(), 1), (float)LikeFood.seed.smeltExperience());
        }
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(null, new ItemStack((Item)INSTANCE, VfpCapacity.DENSE_CRYSTAL_BATCH.count(), 1), new Object[]{VfpObj.Sunflower_plant_obj.func_77946_l(), "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[1].fmlid())), LikeFood.seed.craftExperience() * 16.0f));
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack any() {
        return new ItemStack((Item)INSTANCE, 1, Short.MAX_VALUE);
    }

    public static final ItemStack sunflower(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 1);
    }
}

