/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jwaresoftware.mcmods.vfp.common.FoodPortion;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;
import org.jwaresoftware.mcmods.vfp.misc.DeckerSandwiches;

public class KingDeckerSandwichRecipe
extends VfpRecipe {
    private static final int _MAX_DECKER_FOOD_VALUE = LikeFood.BASE_DECKER.healAmount();
    private static final int _MAX_KINGME_FOOD_VALUE = LikeFood.TOWERING_MEGAWICH.healAmount() + LikeFood.TYPICAL_FOOD_PORTION.healAmount();
    private static final int[] _2x2_FILLED_a = new int[]{0, 2};
    private static final int[] _2x2_BLANKS_a = new int[]{1, 3};
    private static final int[] _2x2_FILLED_b = new int[]{1, 3};
    private static final int[] _2x2_BLANKS_b = new int[]{0, 2};
    private static final int[] _3x3_FILLED_a = new int[]{0, 3, 6};
    private static final int[] _3x3_BLANKS_a = new int[]{1, 2, 4, 5, 7, 8};
    private static final int[] _3x3_FILLED_b = new int[]{0, 3};
    private static final int[] _3x3_BLANKS_b = new int[]{1, 2, 4, 5, 6, 7, 8};

    public ItemStack func_77571_b() {
        return MinecraftGlue.ItemStacks_NULLSTACK();
    }

    public boolean func_194133_a(int width, int height) {
        return this.canFitCommonTableGrid(width, height, false);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)grid);
    }

    private boolean matches(InventoryCrafting grid, String id, int[] filled, int[] blanks) {
        ItemStack stack;
        int iindex;
        for (iindex = 0; iindex < filled.length; ++iindex) {
            stack = grid.func_70301_a(filled[iindex]);
            ItemFood food = FoodPortion.toFood(stack);
            if (food == null) {
                return false;
            }
            if (food == VfpObj.Decker_Sandwiches_obj || MinecraftGlue.RID.matches(stack, "foodSandwich")) continue;
            return false;
        }
        for (iindex = 0; iindex < blanks.length - 1; ++iindex) {
            stack = grid.func_70301_a(blanks[iindex]);
            if (MinecraftGlue.ItemStacks_isEmpty(stack)) continue;
            return false;
        }
        stack = grid.func_70301_a(blanks[blanks.length - 1]);
        return VfpObj.Sandwich_Press_Plate_obj == stack.func_77973_b();
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        int rgrid = grid.func_70302_i_();
        if (rgrid == MinecraftGlue.TABLE_CRAFT_GRID_SIZE()) {
            if (this.matches(grid, "3x3(a)", _3x3_FILLED_a, _3x3_BLANKS_a)) {
                return true;
            }
            if (this.matches(grid, "3x3(b)", _3x3_FILLED_b, _3x3_BLANKS_b)) {
                return true;
            }
        } else if (rgrid == MinecraftGlue.PLAYER_CRAFT_GRID_SIZE()) {
            if (this.matches(grid, "2x2(a)", _2x2_FILLED_a, _2x2_BLANKS_a)) {
                return true;
            }
            if (this.matches(grid, "2x2(b)", _2x2_FILLED_b, _2x2_BLANKS_b)) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        int foodTotal = 0;
        int n = grid.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            ItemStack stack = grid.func_70301_a(i);
            ItemFood food = FoodPortion.toFood(stack);
            if (food == null) continue;
            int sandwichTotal = DeckerSandwiches.getIngredientFoodTotal(food, stack);
            if (sandwichTotal > _MAX_DECKER_FOOD_VALUE && stack.func_77973_b() == VfpObj.Decker_Sandwiches_obj) {
                return MinecraftGlue.ItemStacks_NULLSTACK();
            }
            if ((foodTotal += sandwichTotal) < _MAX_KINGME_FOOD_VALUE) continue;
            return MinecraftGlue.ItemStacks_NULLSTACK();
        }
        return DeckerSandwiches.kingme((IItemHandler)new InvWrapper((IInventory)grid));
    }
}

