/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.TANHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class Juices
extends VfpLiquidMultiItem
implements IReheatable {
    public static final int GENERIC_JUICE_COLOR = 10796325;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>();
    private static final VfpVariantSet VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.Juice, (Class)Juices.class){

        @Override
        protected VfpVariant[] declaredVariants() {
            return this.values().toArray(VfpVariant.EMPTY_ARRAY);
        }
    };
    private static Juices INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Flavor flavor) {
        return Juices.register(flavor, VARIANT_FLAVORS, "juice");
    }

    public Juices(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, LiquidType.JUICE, tab);
        this.func_185043_a(new ResourceLocation("temperature"), new IReheatable.TemperaturePropertyGetter(false));
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 10796325;
        }
        return colorValue;
    }

    @Override
    public int getCoolDuration(ItemStack juice) {
        int duration = IReheatable.super.getCoolDuration(juice);
        Flavor flavor = VfpVariant.byItemStack(juice, this._variant_default).datadata(Flavor.class);
        if ("cactus".equals(flavor.name())) {
            duration *= 2;
        }
        return duration;
    }

    @Override
    public int getBonusTemperatureTimeLeftForApply(ItemStack juice, int min) {
        if (min <= 0) {
            min = 90;
        }
        return Math.max(min, this.getBonusTemperatureTimeLeft(juice));
    }

    private boolean isFortified(ItemStack juice) {
        boolean is = false;
        if (!juice.func_190926_b()) {
            Flavor flavor = VfpVariant.byItemStack(juice, this._variant_default).datadata(Flavor.class);
            is = flavor.isFortified();
        }
        return is;
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (this.isCooled(original) && !MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            PotionType what = VfpPotionTypes.VIGOR;
            if (this.isFortified(original)) {
                what = VfpPotionTypes.STRONG_VIGOR;
            }
            MinecraftGlue.Potions.addPotionEffects((EntityLivingBase)player, what);
        }
    }

    @Override
    public int getThirstQuenched(ItemStack juice) {
        int amount = super.getThirstQuenched(juice);
        if (this.isFortified(juice)) {
            amount = LiquidType.POWER.getThirst();
        }
        return amount;
    }

    @Override
    public float getHydrationAdded(ItemStack juice) {
        float amount = super.getHydrationAdded(juice);
        if (this.isFortified(juice)) {
            amount = LiquidType.POWER.getHydration();
        }
        return amount;
    }

    @Override
    public int getTemperatureModifier(ItemStack juice) {
        int modifier = super.getTemperatureModifier(juice);
        if (this.isFortified(juice)) {
            modifier *= 2;
        }
        return modifier;
    }

    public void func_77622_d(ItemStack juice, World world, EntityPlayer player) {
        IReheatable.ConsumedEffect e = this.onCreateCheckBonusTemperature(juice);
        super.func_77622_d(juice, world, player);
        if (IReheatable.ConsumedEffect.COOLED.equals((Object)e)) {
            this.setCooled(juice);
        }
    }

    public void func_77663_a(ItemStack juice, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(juice, world, holder, slotindex, selected);
    }

    static final Juices makeObjects() {
        if (INSTANCE == null && VARIANT_FLAVORS.size() > 0) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(23);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, LikeFood.juice, ingredient, null, VARIANT_SET));
            }
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Juice, Juices.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        Juices.registerAllUnderDictEntry("foodDrink");
    }

    public static final void registerAllUnderDictEntry(String forgeid) {
        if (INSTANCE != null) {
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_juice_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)forgeid, (ItemStack)a_juice_drink);
            }
        }
    }

    static final void buildRecipes(@Nonnull IForgeRegistry<IRecipe> recipes) {
        if (INSTANCE != null && TYPED_INSTANCES == null) {
            boolean VAN_recipe;
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(13);
            boolean TAN_recipe = MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.ICE_CUBE != null;
            boolean bl = VAN_recipe = !TAN_recipe;
            if (!VfpConfig.getInstance().includeTANRecipes()) {
                TAN_recipe = false;
            }
            for (int i = 0; i < VARIANT_FLAVORS.size(); ++i) {
                Flavor ingredient = (Flavor)VARIANT_FLAVORS.get(i);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                ItemStack juice_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                if (!ingredient.isUncommon()) {
                    String mainitem = ingredient.isClassifier() ? ingredient.recipeitemName() : ingredient.recipeitem();
                    Object ingredient2 = ingredient.recipeitem2();
                    if (ingredient2 == null) {
                        recipes.register(new ShapedOreRecipe(null, juice_drink, new Object[]{"xx", "b ", Character.valueOf('x'), mainitem, Character.valueOf('b'), ingredient.isDiluted() ? "itemWaterBottle" : "itemEmptyBottle"}).setRegistryName(ModInfo.r(ingredient.fmlid())));
                    } else {
                        recipes.register(new ShapedOreRecipe(null, juice_drink, new Object[]{"xx", "yb", Character.valueOf('x'), mainitem, Character.valueOf('y'), ingredient2, Character.valueOf('b'), ingredient.isDiluted() ? "itemWaterBottle" : "itemEmptyBottle"}).setRegistryName(ModInfo.r(ingredient.fmlid())));
                    }
                }
                ItemStack chilled_drink = INSTANCE.asOutput(IReheatable.ConsumedEffect.COOLED, juice_drink);
                if (TAN_recipe) {
                    recipes.register(new ShapelessOreRecipe(null, chilled_drink, new Object[]{juice_drink, TANHelper.ICE_CUBE}).setRegistryName(ModInfo.r("ice_chilled_" + ingredient.fmlid())));
                }
                if (!VAN_recipe) continue;
                recipes.register(new ShapelessOreRecipe(null, chilled_drink, new Object[]{juice_drink, MinecraftGlue.Items_snowball}).setRegistryName(ModInfo.r("chilled_" + ingredient.fmlid())));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final class Flavor
    extends Ingredient
    implements FoodColor {
        private boolean _uncommonFlag;
        private final int _colorValue;
        private final Object _secondaryIngredient;
        private boolean _dilutedFlag;
        private boolean _powerFlag;

        public Flavor(String name, int id, MinecraftGlue.ItemStackDef primary, Object secondary, int colorValue) {
            super(name, id, primary, 2);
            this._secondaryIngredient = secondary;
            this._colorValue = colorValue >= 0 ? colorValue : 10796325;
        }

        public Flavor(String name, int id, Item primary, Object secondary, int colorValue) {
            this(name, id, new MinecraftGlue.ItemStackDef(primary), secondary, colorValue);
        }

        public Flavor(String name, int id, String primary, Object secondary, int colorValue) {
            this(name, id, DictionaryNameItemAdaptor.newi(primary), secondary, colorValue);
        }

        @Override
        public int color(ItemStack stack) {
            return this._colorValue;
        }

        public Object recipeitem2() {
            return this._secondaryIngredient instanceof MinecraftGlue.ItemStackDef ? MinecraftGlue.ItemStackDef.convert(this._secondaryIngredient) : this._secondaryIngredient;
        }

        public String fmlid() {
            return VfpOid.Juice.fmlid() + "_" + this.name();
        }

        public Flavor setDiluted() {
            this._dilutedFlag = true;
            return this;
        }

        public final boolean isDiluted() {
            return this._dilutedFlag;
        }

        public Flavor setUncommon() {
            this._uncommonFlag = true;
            return this;
        }

        public final boolean isUncommon() {
            return this._uncommonFlag;
        }

        public Flavor setFortified() {
            this._powerFlag = true;
            return this;
        }

        public final boolean isFortified() {
            return this._powerFlag;
        }
    }
}

