/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;

public final class CutterExtractHeatPortionsRecipe
extends VfpRecipe {
    private int smeltCount(Item item, ItemStack stack) {
        int bT = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (bT <= 0 || bT > MinecraftGlue.BurnTimes.FULL_STACK_BURN_TIME) {
            return -1;
        }
        return bT /= 200;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        if (!VfpConfig.getInstance().allowGeneralFlintCutter()) {
            return false;
        }
        int n_cutter = 0;
        int n_marker = 0;
        int n = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next)) continue;
            Item item = next.func_77973_b();
            if (MinecraftGlue.RID.matches(next, "itemFoodCutter", VfpObj.Flint_Cutter_obj)) {
                ++n_cutter;
            } else if (item == VfpObj.Heat_Portion_obj) {
                ++n_marker;
            } else {
                if (this.smeltCount(item, next) <= 0) {
                    return false;
                }
                ++n;
            }
            if (n_cutter <= 1 && n_marker <= 1) continue;
            return false;
        }
        return n_cutter == 1 && n_marker == 1 && n == 1;
    }

    public ItemStack func_77571_b() {
        return MinecraftGlue.ItemStacks_NULLSTACK();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 2;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            Item item;
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next) || (item = next.func_77973_b()) == VfpObj.Heat_Portion_obj || MinecraftGlue.RID.matches(next, "itemFoodCutter", VfpObj.Flint_Cutter_obj)) continue;
            int n = this.smeltCount(item, next);
            if (n <= 0) break;
            out = new ItemStack(VfpObj.Heat_Portion_obj, Math.min(MinecraftGlue.MAX_STACK_SIZE(), n + 1));
            break;
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)grid);
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new CutterExtractHeatPortionsRecipe();
        }
    }
}

