/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpStew;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.core.crafting.EmptyBottlesLeftoverShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.milk.BowlOfMilk;
import org.jwaresoftware.mcmods.vfp.milk.CondensedMilkHelper;
import org.jwaresoftware.mcmods.vfp.milk.CreamSoups;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrinks;
import org.jwaresoftware.mcmods.vfp.milk.TeaDrinks;

public final class MilkExtrasBuildHelper
extends VfpBuildHelperSupport {
    private CondensedMilkHelper _condensedHelper = new CondensedMilkHelper();

    @Override
    protected String categoryName() {
        return "MilkExtras";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        VfpObj.Cloth_Bag_obj = VfpBuilder.newMisc(VfpOid.Cloth_Bag);
        MilkDrinks.register(FoodPowders.Type.COCOA);
        MilkDrinks.register(FoodPowders.Type.CREAM);
        MilkDrinks.register(FoodPowders.Type.PUMPKIN);
        MilkDrinks.register(FoodPowders.Type.CACTUS);
        MilkDrinks.register(FoodPowders.Type.APPLE);
        MilkDrinks.register(FoodPowders.Type.MUSCLE);
        String[] others = new String[]{"blueberry", "strawberry", "peanuts", "mocha"};
        for (String other : others) {
            FoodPowders.Type powder = FoodPowders.findType(other);
            if (powder == null) continue;
            MilkDrinks.register(powder);
        }
        VfpObj.CheeseBall_obj = VfpBuilder.newFood(VfpOid.Cheese_Ball, LikeFood.cheese_portion);
        VfpObj.Cheese_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Cheese_Pantry_Block, VfpObj.CheeseBall_obj);
        VfpObj.Cheese_Sandwich_obj = VfpBuilder.newFood(VfpOid.Cheese_Sandwich, LikeFood.cheese_sandwich);
        VfpObj.Butter_obj = VfpBuilder.newFood(VfpOid.Homemade_Butter, LikeFood.butter);
        VfpObj.Portion_Butter_obj = VfpBuilder.newAdditive(VfpOid.Portion_Butter, MinecraftGlue.CreativeTabs_materials);
        VfpObj.Butter_Brick_obj = VfpBuilder.newItem(VfpOid.Butter_Brick);
        TeaDrinks.register(FoodPowders.Type.BUSHTEA);
        TeaDrinks.register(new Ingredient("milky_bushtea", FoodPowders.Usage.DRINK_FLAVOR.idFirst() + 0, FoodPowders.getDef(FoodPowders.Type.BUSHTEA, 1), 2), 11060315);
        TeaDrinks.register(FoodPowders.Type.DANDTEA);
        TeaDrinks.register(new Ingredient("milky_dandtea", FoodPowders.Usage.DRINK_FLAVOR.idFirst() + 1, FoodPowders.getDef(FoodPowders.Type.DANDTEA, 1), 2), 13943960);
        for (FoodPowders.Type powder : FoodPowders.Type.values()) {
            if (!powder.isSoupFlavor()) continue;
            CreamSoups.register(powder);
        }
        VfpObj.Fish_Chowder_obj = VfpBuilder.newStew(VfpOid.Fish_Chowder, LikeFood.fish_chowder);
        VfpObj.Potato_Chowder_obj = VfpBuilder.newStew(VfpOid.Potato_Chowder, LikeFood.tato_chowder);
        this._condensedHelper.makeObjects(runtime);
    }

    @Override
    public void makeObjectsFinalPass(VfpRuntime runtime) {
        VfpObj.Bowl_Milk_obj = new BowlOfMilk();
        VfpObj.MilkDrinks_obj = MilkDrinks.makeObjects();
        VfpObj.TeaDrinks_obj = TeaDrinks.makeObjects();
        VfpObj.CreamSoups_obj = CreamSoups.makeObjects();
        this._condensedHelper.makeObjectsFinalPass(runtime);
    }

    @Override
    public void linkObjects(VfpRuntime runtime) {
        this._condensedHelper.linkObjects(runtime);
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        LikeFood.milk.food().item(MilkDrinks.plain(1));
        LikeFood.cream.food().item(MilkDrinks.heavy(1));
        LikeFood.sweet_milk.food().item(MilkDrinks.other(FoodPowders.Type.CREAM, 1));
        LikeFood.cheese_portion.food().item(VfpObj.CheeseBall_obj);
        LikeFood.cheese_sandwich.food().item(VfpObj.Cheese_Sandwich_obj);
        LikeFood.bush_tea.food().item(TeaDrinks.bush(1));
        LikeFood.butter.food().item(VfpObj.Butter_obj);
        LikeFood.butter_dab.food().item(VfpObj.Portion_Butter_obj);
        this._condensedHelper.linkLikeFoods(runtime);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"itemCheeseCloth", (Item)VfpObj.Cloth_Bag_obj);
        OreDictionary.registerOre((String)"foodCheese", (Item)VfpObj.CheeseBall_obj);
        OreDictionary.registerOre((String)"ingredientCheese", (Item)VfpObj.CheeseBall_obj);
        OreDictionary.registerOre((String)"foodSandwich", (Item)VfpObj.Cheese_Sandwich_obj);
        OreDictionary.registerOre((String)"ingredientButter", (Item)VfpObj.Portion_Butter_obj);
        OreDictionary.registerOre((String)"ingredientCondiment", (Item)VfpObj.Portion_Butter_obj);
        OreDictionary.registerOre((String)"foodButter", (Item)VfpObj.Butter_obj);
        OreDictionary.registerOre((String)"ingredientButterStickOrOil", (Item)VfpObj.Butter_obj);
        OreDictionary.registerOre((String)"foodCurative", (Item)VfpObj.Bowl_Milk_obj);
        OreDictionary.registerOre((String)"portionMilk", (Item)VfpObj.Bowl_Milk_obj);
        OreDictionary.registerOre((String)"ingredientMilk", (Item)VfpObj.Bowl_Milk_obj);
        OreDictionary.registerOre((String)"portionMilk", (ItemStack)MilkDrinks.plain(1));
        OreDictionary.registerOre((String)"ingredientMilk", (ItemStack)MilkDrinks.plain(1));
        OreDictionary.registerOre((String)"ingredientCream", (ItemStack)MilkDrinks.heavy(1));
        OreDictionary.registerOre((String)"foodStew", (Item)VfpObj.Fish_Chowder_obj);
        OreDictionary.registerOre((String)"foodStew", (Item)VfpObj.Potato_Chowder_obj);
        MilkDrinks.addDictionaryEntries();
        TeaDrinks.addDictionaryEntries();
        CreamSoups.addDictionaryEntries();
        this._condensedHelper.addDictionaryEntries(runtime);
    }

    @Override
    public void addLootEntries(VfpRuntime runtime) {
        ItemStack muscle_milk = MilkDrinks.other(FoodPowders.Type.MUSCLE, 1);
        LootEntryItem e = MinecraftGlue.Loot.createEntryItem("muscle_milkdrink", muscle_milk, 1, 2, MinecraftGlue.JUNK_WEIGHT());
        MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186422_d, "pool1", (LootEntry)e);
        this._condensedHelper.addLootEntries(runtime);
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        String tieObject = "string";
        if (VfpUtils.ingredientDefined("itemTieNormal")) {
            tieObject = "itemTieNormal";
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Cloth_Bag_obj, VfpCapacity.MAX_STACK_LCD.count() * 3), new Object[]{" t ", "wsw", " w ", Character.valueOf('w'), new ItemStack(MinecraftGlue.Blocks_wool), Character.valueOf('s'), tieObject, Character.valueOf('t'), "stickWood"}).setRegistryName(ModInfo.r(VfpOid.Cloth_Bag.fmlid())));
        MilkDrinks.buildRecipes(recipes);
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(null, new ItemStack(VfpObj.CheeseBall_obj, 2), new Object[]{"portionMilkLarge", "additiveMilkCurdle", "itemCheeseCloth", VfpObj.Weighted_Plate_obj}).setRegistryName(ModInfo.r(VfpOid.Cheese_Ball.fmlid())), LikeFood.cheese_portion.craftExperience()));
        VfpBuilder.autorecipe(recipes, "Cheese", VfpOid.Cheese_Pantry_Block.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.CheeseBall_obj, VfpObj.Cheese_Pantry_Block_obj, VfpObj.CheeseBall_obj);
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack(VfpObj.Cheese_Sandwich_obj, VfpCapacity.SANDWICH_BATCH.count()), new Object[]{"ccc", " b ", Character.valueOf('c'), "foodCheese", Character.valueOf('b'), "foodBreadSandwich"}).setRegistryName(ModInfo.r(VfpOid.Cheese_Sandwich.fmlid() + "_batch")), LikeFood.sandwich.craftExperience()));
        recipes.register(new ShapelessOreRecipe(null, VfpObj.Cheese_Sandwich_obj, new Object[]{"foodCheese", "portionBread"}).setRegistryName(ModInfo.r(VfpOid.Cheese_Sandwich.fmlid())));
        VfpRewards.addRewardingCraftItem(new ItemStack(VfpObj.Butter_obj, 2), LikeFood.butter.craftExperience());
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Portion_Butter_obj, 4), new Object[]{VfpObj.Butter_obj}).setRegistryName(ModInfo.r(VfpOid.Portion_Butter.fmlid())));
        VfpBuilder.autorecipe(recipes, "Cheese", VfpOid.Butter_Brick.fmlid(), VfpCapacity.PORTABLE, (Object)VfpObj.Butter_obj, VfpObj.Butter_Brick_obj, VfpObj.Butter_obj);
        TeaDrinks.buildRecipes(recipes);
        CreamSoups.buildRecipes(recipes);
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new EmptyBottlesLeftoverShapedOreRecipe(false, ((VfpStew)VfpObj.Fish_Chowder_obj).createInstance(3), "CSC", "pmc", "bbb", Character.valueOf('S'), "ingredientChowderMain", Character.valueOf('C'), "ingredientChowderFill", Character.valueOf('p'), MinecraftGlue.Items_baked_potato, Character.valueOf('c'), "foodCarrot", Character.valueOf('m'), MilkDrinks.heavy(1), Character.valueOf('b'), "bowlWood").setRegistryName(ModInfo.r(VfpOid.Fish_Chowder.fmlid())), VfpOid.Fish_Chowder.craftingXp()));
        IReheatable.REHEATABLES.add(((VfpStew)VfpObj.Fish_Chowder_obj).createInstance(1));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new EmptyBottlesLeftoverShapedOreRecipe(false, ((VfpStew)VfpObj.Potato_Chowder_obj).createInstance(3), "ppp", "hmh", "bbb", Character.valueOf('p'), "foodPotato", Character.valueOf('h'), VfpObj.Portion_Ham_obj, Character.valueOf('m'), MilkDrinks.heavy(1), Character.valueOf('b'), "bowlWood").setRegistryName(ModInfo.r(VfpOid.Potato_Chowder.fmlid())), VfpOid.Potato_Chowder.craftingXp()));
        IReheatable.REHEATABLES.add(((VfpStew)VfpObj.Potato_Chowder_obj).createInstance(1));
        this._condensedHelper.buildRecipes(runtime, recipes);
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cloth_Bag, VfpObj.Cloth_Bag_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cheese_Ball, VfpObj.CheeseBall_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cheese_Pantry_Block, VfpObj.Cheese_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cheese_Sandwich, VfpObj.Cheese_Sandwich_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fish_Chowder, VfpObj.Fish_Chowder_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Potato_Chowder, VfpObj.Potato_Chowder_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bowl_Milk, VfpObj.Bowl_Milk_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.MilkDrink, VfpObj.MilkDrinks_obj, MilkDrinks.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.TeaDrink, VfpObj.TeaDrinks_obj, TeaDrinks.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.CreamSoup, VfpObj.CreamSoups_obj, CreamSoups.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Homemade_Butter, VfpObj.Butter_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Butter, VfpObj.Portion_Butter_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Butter_Brick, VfpObj.Butter_Brick_obj);
        }
        this._condensedHelper.linkRenderModels(runtime);
    }

    @Override
    public void finish(VfpRuntime runtime) {
        this._condensedHelper.finish(runtime);
    }
}

