/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.meats.WolfsSpiritElement;

public class WolfItems
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "WolfDrops";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        VfpObj.Wolf_Raw_obj = VfpBuilder.newFood(VfpOid.Wolf_Raw, LikeFood.uncooked_wolf);
        VfpObj.Wolf_Cooked_obj = VfpBuilder.newFood(VfpOid.Wolf_Cooked, LikeFood.wolf);
        VfpObj.Wolf_Spirit_obj = VfpBuilder.newBrewingItem(VfpOid.Wolf_Spirit, false);
        VfpObj.Wolf_Spirit_Element_obj = WolfsSpiritElement.makeObjects();
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        LikeFood.wolf.food().item(VfpObj.Wolf_Cooked_obj);
        LikeFood.uncooked_wolf.food().item(VfpObj.Wolf_Raw_obj);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Wolf_Raw_obj);
        OreDictionary.registerOre((String)"foodProteinCooked", (Item)VfpObj.Wolf_Cooked_obj);
    }

    @Override
    public void addLootEntries(VfpRuntime runtime) {
        if (runtime.getConfig().includeModDrops() && runtime.getConfig().includeWolfDrops()) {
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186430_l, null, (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Wolf_Spirit.fmlid(), VfpObj.Wolf_Spirit_obj, MinecraftGlue.TREASURE_WEIGHT(), 2));
        }
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        if (runtime.getConfig().includePotionBrewing()) {
            MinecraftGlue.BrewEffect.addRecipeFor(VfpObj.Wolf_Spirit_obj, 0, VfpPotionTypes.WOLF_SPIRIT);
            MinecraftGlue.BrewEffect.addThickConversionFor(VfpObj.Wolf_Spirit_obj, 0, VfpPotionTypes.WOLF_SPIRIT);
            MinecraftGlue.BrewEffect.addRecipeForAnyOf(VfpObj.Wolf_Spirit_Element_obj, VfpPotionTypes.WOLF_SPIRIT, VfpPotionTypes.SUPER_WOLF_SPIRIT);
        }
        GameRegistry.addSmelting((Item)VfpObj.Wolf_Raw_obj, (ItemStack)new ItemStack(VfpObj.Wolf_Cooked_obj), (float)LikeFood.uncooked_wolf.smeltExperience());
        ItemStack anyElement = new ItemStack(VfpObj.Wolf_Spirit_Element_obj, 1, Short.MAX_VALUE);
        recipes.register(new ShapelessOreRecipe(null, VfpObj.Wolf_Spirit_obj, new Object[]{anyElement, "nuggetGold", "nuggetGold"}).setRegistryName(ModInfo.r(VfpOid.Wolf_Spirit.fmlid())));
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Raw, VfpObj.Wolf_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Cooked, VfpObj.Wolf_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Spirit, VfpObj.Wolf_Spirit_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Spirit_Element, VfpObj.Wolf_Spirit_Element_obj, WolfsSpiritElement.variants());
        }
    }
}

