/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class Kebabs
extends VfpPantryMultiItem {
    private static final int KEBAB_BATCH = 4;
    private static final int SMALL_KEBAB_BATCH = 2;
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Kebab, Kebabs.class, "type");
    private static final VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, "kebab_meat_raw", LikeFood.uncooked_kebab, VARIANT_SET, true), new VfpVariant(1, "kebab_meat", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(2, "kebab_poultry_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(3, "kebab_poultry", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(4, "kebab_fish_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(5, "kebab_fish", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(6, "kebab_veggie_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(7, "kebab_veggie", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(8, "kebab_fruit_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(9, "kebab_fruit", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(10, "kebab_adventure_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(11, "kebab_adventure", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(12, "kebab_bear_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(13, "kebab_bear", LikeFood.kebab_heavy, VARIANT_SET, false)};
    private static Kebabs INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private static final int _MEAT_KEBAB_RAW = 0;
    private static final int _POULTRY_KEBAB_RAW = 2;
    private static final int _FISH_KEBAB_RAW = 4;
    private static final int _VEGGIE_KEBAB_RAW = 6;
    private static final int _FRUIT_KEBAB_RAW = 8;
    private static final int _BEAR_KEBAB_RAW = 12;

    public Kebabs(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    static final synchronized Kebabs makeObjects() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Kebab, Kebabs.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            for (int meta = 0; meta < VARIANT_ARRAY.length; meta += 2) {
                if (meta == 8) {
                    OreDictionary.registerOre((String)"foodKebabFruit", (ItemStack)Kebabs.kebab(meta));
                    OreDictionary.registerOre((String)"foodKebabFruit", (ItemStack)Kebabs.kebab(meta + 1));
                    continue;
                }
                if (meta == 6) {
                    OreDictionary.registerOre((String)"foodKebabVeggie", (ItemStack)Kebabs.kebab(meta + 1));
                    continue;
                }
                OreDictionary.registerOre((String)"foodKebabGoodMeat", (ItemStack)Kebabs.kebab(meta + 1));
            }
        }
    }

    private static final void addMKebabs(IForgeRegistry<IRecipe> recipes, int raw_meta, int cooked_meta, PackagedFood[] meats, boolean is_fish, List<ItemStack> instances) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 1, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        instances.add(raw_kebab);
        instances.add(kebab);
        GameRegistry.addSmelting((ItemStack)raw_kebab.func_77946_l(), (ItemStack)kebab, (float)LikeFood.uncooked_kebab.smeltExperience());
        raw_kebab = new ItemStack((Item)INSTANCE, is_fish ? 2 : 4, raw_meta);
        for (PackagedFood meat : meats) {
            ItemStack _main = meat.food().sample();
            recipes.register(new ShapedOreRecipe(null, raw_kebab, new Object[]{"vv", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('m'), _main, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r(VARIANT_ARRAY[raw_meta].fmlid() + "_from_" + meat.fmlid_suffix())));
        }
    }

    private static final void addVKebabs(IForgeRegistry<IRecipe> recipes, int raw_meta, int cooked_meta, List<ItemStack> instances) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 4, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        recipes.register(new ShapedOreRecipe(null, raw_kebab, new Object[]{"vv", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('m'), "ingredientKebabMain", Character.valueOf('s'), VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r(VARIANT_ARRAY[raw_meta].fmlid())));
        MinecraftGlue.ItemStacks_setSize(raw_kebab, 2);
        recipes.register(new ShapelessOreRecipe(null, raw_kebab, new Object[]{VfpObj.Raw_Veg_Medley_obj, VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r(VARIANT_ARRAY[raw_meta].fmlid() + "_alt1")));
        MinecraftGlue.ItemStacks_setSize(raw_kebab, 1);
        GameRegistry.addSmelting((ItemStack)raw_kebab.func_77946_l(), (ItemStack)kebab.func_77946_l(), (float)LikeFood.uncooked_kebab.smeltExperience());
        instances.add(raw_kebab);
        instances.add(kebab);
    }

    private static final void addFKebabs(IForgeRegistry<IRecipe> recipes, int raw_meta, int cooked_meta, List<ItemStack> instances, VfpConfig config) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 2, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        recipes.register(new ShapedOreRecipe(null, raw_kebab, new Object[]{"vv", "xs", Character.valueOf('v'), "ingredientKebabFruit", Character.valueOf('x'), "ingredientSweetener", Character.valueOf('s'), VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r(VARIANT_ARRAY[raw_meta].fmlid())));
        if (config.isPresent("mini_fruit")) {
            recipes.register(new ShapedOreRecipe(null, raw_kebab, new Object[]{"vvv", "vvv", "xs ", Character.valueOf('v'), "ingredientKebabMiniFruit", Character.valueOf('x'), "ingredientSweetener", Character.valueOf('s'), VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r(VARIANT_ARRAY[raw_meta].fmlid() + "_alt1")));
        }
        MinecraftGlue.ItemStacks_setSize(raw_kebab, 1);
        GameRegistry.addSmelting((ItemStack)raw_kebab.func_77946_l(), (ItemStack)kebab.func_77946_l(), (float)LikeFood.uncooked_kebab.smeltExperience());
        instances.add(raw_kebab);
        instances.add(kebab);
    }

    private static final void addAKebabs(IForgeRegistry<IRecipe> recipes, int raw_meta, int cooked_meta, List<ItemStack> instances) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 4, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        String _main = "ingredientKebabAdventure";
        recipes.register(new ShapedOreRecipe(null, raw_kebab, new Object[]{"vv", "cS", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('c'), FoodPowders.get(FoodPowders.Type.CACTUS, 1), Character.valueOf('S'), "portionSaltSmall", Character.valueOf('m'), _main, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r(VARIANT_ARRAY[raw_meta].fmlid())));
        MinecraftGlue.ItemStacks_setSize(raw_kebab, 1);
        GameRegistry.addSmelting((ItemStack)raw_kebab.func_77946_l(), (ItemStack)kebab.func_77946_l(), (float)LikeFood.uncooked_kebab.smeltExperience());
        instances.add(raw_kebab);
        instances.add(kebab);
    }

    private static final void addBKebabs(IForgeRegistry<IRecipe> recipes, int raw_meta, int cooked_meta, List<ItemStack> instances) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 4, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        Item _main = VfpObj.Bear_Raw_Prepped_obj;
        recipes.register(new ShapedOreRecipe(null, raw_kebab, new Object[]{"vv", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('m'), _main, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r(VARIANT_ARRAY[raw_meta].fmlid())));
        MinecraftGlue.ItemStacks_setSize(raw_kebab, 1);
        GameRegistry.addSmelting((ItemStack)raw_kebab.func_77946_l(), (ItemStack)kebab.func_77946_l(), (float)LikeFood.uncooked_kebab.smeltExperience());
        instances.add(raw_kebab);
        instances.add(kebab);
    }

    static final void buildRecipes(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (INSTANCE != null && TYPED_INSTANCES == null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(29);
            Kebabs.addMKebabs(recipes, 0, 1, new PackagedFood[]{PackagedFood.BEEF, PackagedFood.MUTTON, PackagedFood.LLAMA}, false, instances);
            Kebabs.addMKebabs(recipes, 2, 3, new PackagedFood[]{PackagedFood.CHICKEN}, false, instances);
            Kebabs.addMKebabs(recipes, 4, 5, new PackagedFood[]{PackagedFood.CODFISH, PackagedFood.SALMON}, true, instances);
            Kebabs.addVKebabs(recipes, 6, 7, instances);
            Kebabs.addFKebabs(recipes, 8, 9, instances, config);
            Kebabs.addAKebabs(recipes, 10, 11, instances);
            Kebabs.addBKebabs(recipes, 12, 13, instances);
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    private static final ItemStack kebab(int amount, int meta) {
        ItemStack kebab;
        ItemStack itemStack = kebab = TYPED_INSTANCES == null ? new ItemStack((Item)INSTANCE, 1, meta) : TYPED_INSTANCES[meta].func_77946_l();
        if (amount > 1) {
            MinecraftGlue.ItemStacks_setSize(kebab, amount);
        }
        return kebab;
    }

    private static final ItemStack kebab(int meta) {
        return Kebabs.kebab(0, meta);
    }

    public static final ItemStack meat() {
        return Kebabs.kebab(1);
    }

    public static final ItemStack polarbear() {
        return Kebabs.kebab(13);
    }

    public static final ItemStack uncooked_meat(int amount) {
        return Kebabs.kebab(amount, 0);
    }

    public static final ItemStack uncooked_poultry(int amount) {
        return Kebabs.kebab(amount, 2);
    }

    public static final ItemStack uncooked_fish(int amount) {
        return Kebabs.kebab(amount, 4);
    }
}

