/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

final class ImplPNKS {
    ImplPNKS() {
    }

    static final void registerKebabItems(VfpConfig config) {
        Item item;
        if (config.isModLoaded(Integrations.PNK) && (item = Integrations.PNK.item("earthworm_ball")) != null) {
            OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Earthworms_Purged_obj);
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        if (config.isModLoaded(Integrations.PNK)) {
            OreDictionary.registerOre((String)"guardianBait", (Item)VfpObj.Squid_Raw_obj);
            if (config.isModLoaded(Integrations.HVC)) {
                IntegrationsImpl._registerMiscItem(Integrations.HVC, "guardianBait", "octopusrawitem");
                IntegrationsImpl._registerMiscItem(Integrations.HVC, "guardianBait", "eelrawitem");
                IntegrationsImpl._registerMiscItem(Integrations.PNK, "listAllmushroom", "pinkly_fungi");
                IntegrationsImpl._registerMiscItem(Integrations.PNK, "listAllnut", "stalknuts_roasted");
            }
        } else if (config.allowSpawnEggCrafting()) {
            OreDictionary.registerOre((String)"itemSpawnEggCasing", (Item)MinecraftGlue.Items_egg);
        }
    }

    static final void autorecipeMisc(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (config.isModLoaded(Integrations.PNK)) {
            Item item;
            Block block = Integrations.PNK.block("dried_leaves_block");
            if (block != null) {
                recipes.register(new ShapedOreRecipe(null, new ItemStack(block, 2, block.func_176201_c(block.func_176223_P())), new Object[]{"xxx", "xDx", "xxx", Character.valueOf('x'), "treeLeaves", Character.valueOf('D'), "additiveDrying"}).setRegistryName(ModInfo.r("crafted_dried_leaves_block")));
            }
            if ((item = Integrations.PNK.item("earthworm_ball")) != null) {
                recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Earthworms_Purged_obj, 8), new Object[]{"xxx", "xWx", "xxx", Character.valueOf('x'), item, Character.valueOf('W'), "portionPotableWaterLarge"}).setRegistryName(ModInfo.r(VfpOid.Earthworms_Purged.fmlid())));
            }
            if (MinecraftGlue.ingredientDefinedLooking("itemWildPotato")) {
                recipes.register(new ShapelessOreRecipe(null, FoodPowders.get(FoodPowders.Type.POTATO, 2), new Object[]{"itemWildPotato", "itemWildPotato", "additiveDrying"}).setRegistryName(ModInfo.r("foodpowder_potato_from_wild_uns")));
            }
        }
    }

    static final void registerLoot(VfpConfig config) {
        if (config.isModLoaded(Integrations.PNK)) {
            ResourceLocation lucky_nitwit = Integrations.PNK.resource("entities/lucky_nitwit");
            ItemStack loot = new ItemStack(VfpObj.Bat_Poop_obj);
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", lucky_nitwit, "hord_xlootpool", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:bat_poop", loot, MinecraftGlue.UNCOMMON_WEIGHT()));
            loot = new ItemStack(VfpObj.Oak_Acorn_obj);
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", lucky_nitwit, "hord_xlootpool", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:oak_acorn", loot, MinecraftGlue.JUNK_WEIGHT()));
            ResourceLocation trawl_crate = Integrations.PNK.resource("blocks/trawl_crate");
            loot = new ItemStack(VfpObj.Guardian_Fins_obj);
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", trawl_crate, "hord_xlootpool", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:guardian_fins", loot, MinecraftGlue.UNCOMMON_WEIGHT()));
            if (config.includePotionBrewing()) {
                ResourceLocation temple_crate = Integrations.PNK.resource("blocks/trawl_crate_treasure");
                loot = MinecraftGlue.Potions.newPotionHeldItem(VfpPotionTypes.LONG_WATER_NATIVE);
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", temple_crate, "life_lines", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:underwater_worker_potion", loot, MinecraftGlue.UNCOMMON_WEIGHT()));
            }
            ResourceLocation heart_prize = Integrations.PNK.resource("beanstalk/heart");
            loot = new ItemStack(VfpObj.Phoenix_Feather_obj);
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", heart_prize, "prizes", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:phoenix_feather", loot, MinecraftGlue.TREASURE_WEIGHT()));
            ResourceLocation miner_loot = Integrations.PNK.resource("beanstalk/knot_shulkerbox");
            loot = new ItemStack(VfpObj.Nether_RockSalt_OreBlock_obj);
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", miner_loot, "rawmaterials", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:nether_rocksalt", loot, 15));
            ResourceLocation farmers_pouch = Integrations.PNK.resource("gameplay/rewards/plantables");
            loot = new ItemStack(VfpObj.Seed_Drying_Paper_obj);
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", farmers_pouch, "hord_xlootpool", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:seed_drying_paper", loot, MinecraftGlue.JUNK_WEIGHT()));
        }
    }
}

